/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.oaipmh;

import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IAuthenticationHandler;
import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IConfigurable;
import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IRequestHandler;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OaipmhServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String AUTHENTICATION_HANDLER_PARAMETER_NAME = "authentication-handler";
    private static final String REQUEST_HANDLER_PARAMETER_NAME = "request-handler";
    private IAuthenticationHandler authenticationHandler;
    private IRequestHandler requestHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.authenticationHandler = this.initHandler(config, AUTHENTICATION_HANDLER_PARAMETER_NAME, IAuthenticationHandler.class);
        this.requestHandler = this.initHandler(config, REQUEST_HANDLER_PARAMETER_NAME, IRequestHandler.class);
    }

    private <T extends IConfigurable> T initHandler(ServletConfig config, String handlerParameterName, Class<T> handlerInterface) throws ServletException {
        String className = config.getInitParameter(handlerParameterName);
        if (className == null || className.trim().length() == 0) {
            throw new ServletException("Parameter '" + handlerParameterName + "' is null or empty");
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (!handlerInterface.isAssignableFrom(clazz)) {
                throw new ServletException("Handler class '" + clazz.getName() + "' specified in '" + handlerParameterName + "' parameter does not implement '" + handlerInterface.getName() + "' interface");
            }
            IConfigurable instance = (IConfigurable)clazz.newInstance();
            Properties properties = new Properties();
            Enumeration parameterNames = config.getInitParameterNames();
            String handlerParameterNamePrefix = handlerParameterName + ".";
            properties.setProperty("path", config.getInitParameter("path"));
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith(handlerParameterNamePrefix)) continue;
                properties.setProperty(parameterName.substring(handlerParameterNamePrefix.length()), config.getInitParameter(parameterName));
            }
            instance.init(properties);
            return (T)instance;
        }
        catch (Exception ex) {
            throw new ServletException("Cannot create an instance of handler class '" + className + "'", (Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SessionContextDTO session = this.authenticationHandler.handle(req, resp);
        if (session != null) {
            resp.setContentType("text/xml");
            this.requestHandler.handle(session, req, resp);
        }
    }
}

