/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.openbisauth;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.spring.PropertyPlaceholderUtils;
import ch.systemsx.cisd.common.utilities.ICredentials;
import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionTokenManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServerInfo;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatastoreServiceDescriptions;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

public class OpenBISAuthenticationInterceptor
implements MethodInterceptor,
ICredentials {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, OpenBISAuthenticationInterceptor.class);
    private final SessionTokenManager sessionTokenManager;
    private int port;
    private boolean useSSL;
    private String username;
    private String password;
    private String downloadUrl;
    private int timeoutInMinutes;
    private OpenBISSessionHolder sessionHolder;
    private final DatastoreServiceDescriptions pluginTaskDescriptions;
    private final boolean archiverConfigured;
    private final IServiceForDataStoreServer service;
    private final IDataSourceProvider dataSourceProvider;

    public OpenBISAuthenticationInterceptor(SessionTokenManager sessionTokenManager, IServiceForDataStoreServer service, IPluginTaskInfoProvider pluginTaskParameters, IDataSourceProvider dataSourceProvider, OpenBISSessionHolder sessionHolder) {
        this.dataSourceProvider = dataSourceProvider;
        assert (sessionTokenManager != null) : "Unspecified session token manager.";
        assert (service != null) : "Given IETLLIMSService implementation can not be null.";
        assert (pluginTaskParameters != null) : "Unspecified plugin tasks";
        assert (sessionHolder != null) : "Unspecified session holder object.";
        this.sessionTokenManager = sessionTokenManager;
        this.service = service;
        this.pluginTaskDescriptions = pluginTaskParameters.getPluginTaskDescriptions();
        this.archiverConfigured = pluginTaskParameters.getArchiverPluginFactory().isArchiverConfigured();
        this.sessionHolder = sessionHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String sessionToken = this.getSessionToken();
        try {
            return invocation.proceed();
        }
        catch (InvalidSessionException ise) {
            OpenBISAuthenticationInterceptor openBISAuthenticationInterceptor = this;
            synchronized (openBISAuthenticationInterceptor) {
                if (sessionToken == this.sessionHolder.getSessionToken()) {
                    this.authenticate();
                }
            }
            return invocation.proceed();
        }
    }

    private final void authenticate() {
        SessionContextDTO sessionContextDTO;
        String sessionToken;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Authenticating to openBIS server as user '" + this.username + "'."));
        }
        String string = sessionToken = (sessionContextDTO = this.service.tryAuthenticate(this.username, this.password)) == null ? null : sessionContextDTO.getSessionToken();
        if (sessionToken == null) {
            String msg = "Authentication failure to openBIS server. Most probable cause: user or password are invalid.";
            throw new ConfigurationFailureException("Authentication failure to openBIS server. Most probable cause: user or password are invalid.");
        }
        this.sessionHolder.setSessionToken(sessionToken);
        DataStoreServerInfo dataStoreServerInfo = new DataStoreServerInfo();
        dataStoreServerInfo.setPort(this.port);
        dataStoreServerInfo.setUseSSL(this.useSSL);
        dataStoreServerInfo.setDataStoreCode(this.sessionHolder.getDataStoreCode());
        if (this.downloadUrl == null) {
            String msg = "'download-url' can't be null.";
            throw new ConfigurationFailureException("'download-url' can't be null.");
        }
        dataStoreServerInfo.setDownloadUrl(this.downloadUrl);
        dataStoreServerInfo.setSessionToken(this.sessionTokenManager.drawSessionToken());
        dataStoreServerInfo.setServicesDescriptions(this.pluginTaskDescriptions);
        dataStoreServerInfo.setArchiverConfigured(this.archiverConfigured);
        dataStoreServerInfo.setTimeoutInMinutes(this.timeoutInMinutes);
        dataStoreServerInfo.setDataSourceDefinitions(this.dataSourceProvider.getAllDataSourceDefinitions());
        this.service.registerDataStoreServer(sessionToken, dataStoreServerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getSessionToken() {
        if (this.sessionHolder.getSessionToken() == null) {
            OpenBISAuthenticationInterceptor openBISAuthenticationInterceptor = this;
            synchronized (openBISAuthenticationInterceptor) {
                if (this.sessionHolder.getSessionToken() == null) {
                    this.authenticate();
                }
            }
        }
        return this.sessionHolder.getSessionToken();
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final void setUseSSL(String useSSL) {
        this.useSSL = PropertyPlaceholderUtils.getBoolean((String)useSSL, (Boolean)ConfigParameters.getDefaultUseSSL());
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public String getUserId() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setTimeoutInMinutes(String timeoutInMinutes) {
        this.timeoutInMinutes = PropertyPlaceholderUtils.getInteger((String)timeoutInMinutes, (Integer)ConfigParameters.getDefaultServerTimeoutInMinutes());
    }
}

