/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.demo;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.HierarchicalContentTraverseUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentNodeVisitor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ImageTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class DemoReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;

    public DemoReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        builder.addHeader("Dataset Code");
        builder.addHeader("Thumbnail");
        builder.addHeader("Name");
        builder.addHeader("Relative Path");
        builder.addHeader("Last Modified");
        builder.addHeader("Size");
        builder.addHeader("Checksum");
        for (DatasetDescription dataset : datasets) {
            this.describe(builder, dataset);
        }
        return builder.getTableModel();
    }

    private void describe(SimpleTableModelBuilder builder, DatasetDescription dataset) {
        IHierarchicalContentNodeVisitor visitor = this.createFileDescribingVisitor(builder, dataset);
        IHierarchicalContentProvider provider = ServiceProvider.getHierarchicalContentProvider();
        HierarchicalContentTraverseUtil.traverse(provider, dataset.getDataSetCode(), visitor);
    }

    private IHierarchicalContentNodeVisitor createFileDescribingVisitor(final SimpleTableModelBuilder builder, final DatasetDescription dataset) {
        return new IHierarchicalContentNodeVisitor(){

            @Override
            public void visit(IHierarchicalContentNode node) {
                if (!node.isDirectory()) {
                    DemoReportingPlugin.this.describeFileNode(builder, dataset, node);
                }
            }
        };
    }

    private void describeFileNode(SimpleTableModelBuilder builder, DatasetDescription dataset, IHierarchicalContentNode fileNode) {
        ISerializableComparable image = this.createPathOrImageCell(dataset, fileNode);
        List<ISerializableComparable> row = Arrays.asList(new StringTableCell(dataset.getDataSetCode()), image, new StringTableCell(fileNode.getName()), new StringTableCell(fileNode.getRelativePath()), new DateTableCell(new Date(fileNode.getLastModified())), new DoubleTableCell((double)fileNode.getFileLength()), new StringTableCell(Long.toString(fileNode.getChecksumCRC32())));
        builder.addRow(row);
    }

    private ISerializableComparable createPathOrImageCell(DatasetDescription dataset, IHierarchicalContentNode fileNode) {
        File fileOnDisk = null;
        try {
            fileOnDisk = fileNode.getFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (fileOnDisk != null && ImageUtil.isImageFile(fileOnDisk)) {
            return new ImageTableCell(dataset.getDataSetCode(), fileNode.getRelativePath(), 100, 60);
        }
        return new StringTableCell(fileNode.getName());
    }
}

