/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IAggregationServiceReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.ITableModelCreator;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.PluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.Utils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AggregationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JythonAggregationService
extends AggregationService {
    private static final long serialVersionUID = 1L;
    private static final Logger notifyLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, JythonAggregationService.class);
    private final IPluginScriptRunnerFactory scriptRunnerFactory;

    protected static String getScriptPathProperty(Properties properties) {
        return JythonBasedProcessingPlugin.getScriptPathProperty(properties);
    }

    public JythonAggregationService(Properties properties, File storeRoot) {
        this(properties, storeRoot, new PluginScriptRunnerFactory(JythonAggregationService.getScriptPathProperty(properties)));
    }

    protected JythonAggregationService(Properties properties, File storeRoot, IPluginScriptRunnerFactory scriptRunnerFactory) {
        super(properties, storeRoot);
        this.scriptRunnerFactory = scriptRunnerFactory;
    }

    @Override
    public TableModel createAggregationReport(final Map<String, Object> parameters, final DataSetProcessingContext context) {
        ITableModelCreator generator = new ITableModelCreator(){

            @Override
            public void create(ISimpleTableModelBuilderAdaptor builder) {
                operationLog.info((Object)("Aggregation report for the following parameters has been requested: " + parameters.keySet()));
                IAggregationServiceReportingPluginScriptRunner runner = JythonAggregationService.this.scriptRunnerFactory.createAggregationServiceReportingPluginRunner(context);
                try {
                    runner.aggregate(parameters, builder);
                }
                finally {
                    operationLog.info((Object)"Aggregation reporting done.");
                    runner.releaseResources();
                }
            }
        };
        return Utils.generateTableModel(generator, this.scriptRunnerFactory.getScriptPath(), notifyLog);
    }
}

