/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.AuthorizationService;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SearchService;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IAggregationServiceReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IDbModifyingAggregationServiceReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IProcessingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IRequestHandlerPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.MailService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IDataSet;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IMailService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.ISessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.authorization.IAuthorizationService;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PluginScriptRunnerFactory
implements IPluginScriptRunnerFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PluginScriptRunnerFactory.class);
    private static final String SEARCH_SERVICE_VARIABLE_NAME = "searchService";
    private static final String SEARCH_SERVICE_UNFILTERED_VARIABLE_NAME = "searchServiceUnfiltered";
    private static final String DATA_SOURCE_QUERY_SERVICE_VARIABLE_NAME = "queryService";
    private static final String MAIL_SERVICE_VARIABLE_NAME = "mailService";
    private static final String AUTHORIZATION_SERVICE = "authorizationService";
    private static final String CONTENT_PROVIDER_VARIABLE_NAME = "contentProvider";
    private static final String CONTENT_PROVIDER_UNFILTERED_VARIABLE_NAME = "contentProviderUnfiltered";
    private static final String SESSION_WORKSPACE_PROVIDER_NAME = "sessionWorkspaceProvider";
    private static final String USER_ID = "userId";
    private static final String USER_SESSION_TOKEN = "userSessionToken";
    private final String scriptPath;

    public PluginScriptRunnerFactory(String scriptPath) {
        this.scriptPath = scriptPath;
        Evaluator.getFactory().initialize();
    }

    @Override
    public IAggregationServiceReportingPluginScriptRunner createAggregationServiceReportingPluginRunner(DataSetProcessingContext context) {
        String scriptString = JythonUtils.extractScriptFromPath((String)this.scriptPath);
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{this.scriptPath});
        try {
            IJythonEvaluator evaluator = this.createEvaluatorWithContentProviders(context, scriptString, pythonPath);
            return new AggregationServiceReportingPluginScriptRunner(evaluator);
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + this.scriptPath + "]");
        }
    }

    @Override
    public IDbModifyingAggregationServiceReportingPluginScriptRunner createDbModifyingAggregationServiceReportingPluginRunner(DataSetProcessingContext context) {
        String scriptString = JythonUtils.extractScriptFromPath((String)this.scriptPath);
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{this.scriptPath});
        try {
            IJythonEvaluator evaluator = this.createEvaluatorWithContentProviders(context, scriptString, pythonPath);
            return new DbModifyingAggregationServiceReportingPluginScriptRunner(evaluator);
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + this.scriptPath + "]");
        }
    }

    @Override
    public IReportingPluginScriptRunner createReportingPluginRunner(DataSetProcessingContext context) {
        String scriptString = JythonUtils.extractScriptFromPath((String)this.scriptPath);
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{this.scriptPath});
        try {
            return new ReportingPluginScriptRunner(this.createEvaluator(scriptString, pythonPath, context));
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + this.scriptPath + "]");
        }
    }

    @Override
    public IProcessingPluginScriptRunner createProcessingPluginRunner(DataSetProcessingContext context) {
        String scriptString = JythonUtils.extractScriptFromPath((String)this.scriptPath);
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{this.scriptPath});
        try {
            return new ProcessingPluginScriptRunner(this.createEvaluator(scriptString, pythonPath, context));
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + this.scriptPath + "]");
        }
    }

    @Override
    public IRequestHandlerPluginScriptRunner createRequestHandlerPluginRunner(DataSetProcessingContext context) {
        String scriptString = JythonUtils.extractScriptFromPath((String)this.scriptPath);
        String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{this.scriptPath});
        try {
            IJythonEvaluator evaluator = this.createEvaluatorWithContentProviders(context, scriptString, pythonPath);
            return new RequestHandlerPluginScriptRunner(evaluator);
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(ex.getMessage() + " [" + this.scriptPath + "]");
        }
    }

    protected IJythonEvaluator createEvaluator(String scriptString, String[] pythonPath, DataSetProcessingContext context) {
        IJythonEvaluator evaluator = Evaluator.getFactory().create("", pythonPath, this.scriptPath, null, scriptString, false);
        evaluator.set(SEARCH_SERVICE_VARIABLE_NAME, (Object)this.createUserSearchService(context));
        evaluator.set(SEARCH_SERVICE_UNFILTERED_VARIABLE_NAME, (Object)this.createUnfilteredSearchService());
        evaluator.set(MAIL_SERVICE_VARIABLE_NAME, (Object)PluginScriptRunnerFactory.createMailService(context));
        evaluator.set(DATA_SOURCE_QUERY_SERVICE_VARIABLE_NAME, (Object)this.createDataSourceQueryService());
        evaluator.set(AUTHORIZATION_SERVICE, (Object)this.createAuthorizationService());
        evaluator.set(USER_ID, (Object)context.getUserId());
        evaluator.set(USER_SESSION_TOKEN, (Object)context.trySessionToken());
        ISessionWorkspaceProvider workspaceProvider = context.tryGetSessionWorkspaceProvider();
        if (workspaceProvider != null) {
            evaluator.set(SESSION_WORKSPACE_PROVIDER_NAME, (Object)workspaceProvider);
        }
        return evaluator;
    }

    private IJythonEvaluator createEvaluatorWithContentProviders(DataSetProcessingContext context, String scriptString, String[] pythonPath) {
        IJythonEvaluator evaluator = this.createEvaluator(scriptString, pythonPath, context);
        DataSetContentProvider contentProvider = new DataSetContentProvider(context.getHierarchicalContentProvider());
        evaluator.set(CONTENT_PROVIDER_VARIABLE_NAME, (Object)contentProvider);
        DataSetContentProvider contentProviderUnfiltered = new DataSetContentProvider(context.getHierarchicalContentProviderUnfiltered());
        evaluator.set(CONTENT_PROVIDER_UNFILTERED_VARIABLE_NAME, (Object)contentProviderUnfiltered);
        return evaluator;
    }

    protected ISearchService createUserSearchService(DataSetProcessingContext context) {
        if (context.getUserId() == null) {
            return this.createUnfilteredSearchService();
        }
        return new SearchService(ServiceProvider.getOpenBISService().getBasicFilteredOpenBISService(context.getUserId()));
    }

    protected ISearchService createUnfilteredSearchService() {
        return new SearchService(ServiceProvider.getOpenBISService());
    }

    protected IAuthorizationService createAuthorizationService() {
        return new AuthorizationService(ServiceProvider.getOpenBISService());
    }

    protected IDataSourceQueryService createDataSourceQueryService() {
        return new DataSourceQueryService();
    }

    private static IMailService createMailService(DataSetProcessingContext context) {
        return new MailService(context.getMailClient(), context.getUserEmailOrNull());
    }

    @Override
    public String getScriptPath() {
        return this.scriptPath;
    }

    private static class RequestHandlerPluginScriptRunner
    implements IRequestHandlerPluginScriptRunner {
        private static final String FUNCTION_NAME = "handle";
        private final IJythonEvaluator evaluator;

        RequestHandlerPluginScriptRunner(IJythonEvaluator evaluator) {
            this.evaluator = evaluator;
            if (!evaluator.hasFunction(FUNCTION_NAME)) {
                throw new EvaluatorException("Function 'handle' was not defined in the request handler");
            }
        }

        @Override
        public void setVariable(String name, Object value) {
            this.evaluator.set(name, value);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) {
            this.evaluator.evalFunction(FUNCTION_NAME, new Object[]{request, response});
        }

        @Override
        public void releaseResources() {
            this.evaluator.releaseResources();
        }
    }

    private static class ProcessingPluginScriptRunner
    implements IProcessingPluginScriptRunner {
        private static final String PROCESS_FUNCTION_NAME = "process";
        private final IJythonEvaluator evaluator;

        ProcessingPluginScriptRunner(IJythonEvaluator evaluator) {
            this.evaluator = evaluator;
            if (!evaluator.hasFunction(PROCESS_FUNCTION_NAME)) {
                throw new EvaluatorException("Function 'process' was not defined in the processing plugin script");
            }
        }

        @Override
        public Status process(IDataSet dataSet) {
            try {
                this.evaluator.evalFunction(PROCESS_FUNCTION_NAME, new Object[]{dataSet});
            }
            catch (EvaluatorException ex) {
                operationLog.error((Object)ex.getMessage());
                return Status.createError((String)ex.getMessage());
            }
            return Status.OK;
        }

        @Override
        public void releaseResources() {
            this.evaluator.releaseResources();
        }
    }

    private static class ReportingPluginScriptRunner
    implements IReportingPluginScriptRunner {
        private static final String DESCRIBE_FUNCTION_NAME = "describe";
        private final IJythonEvaluator evaluator;

        ReportingPluginScriptRunner(IJythonEvaluator evaluator) {
            this.evaluator = evaluator;
            if (!evaluator.hasFunction(DESCRIBE_FUNCTION_NAME)) {
                throw new EvaluatorException("Function 'describe' was not defined in the reporting plugin script");
            }
        }

        @Override
        public void describe(List<IDataSet> dataSets, ISimpleTableModelBuilderAdaptor tableBuilder) {
            this.evaluator.evalFunction(DESCRIBE_FUNCTION_NAME, new Object[]{dataSets, tableBuilder});
        }

        @Override
        public void releaseResources() {
            this.evaluator.releaseResources();
        }
    }

    private static class DbModifyingAggregationServiceReportingPluginScriptRunner
    extends AbstractAggregationServiceReportingPluginScriptRunner
    implements IDbModifyingAggregationServiceReportingPluginScriptRunner {
        private static final String FUNCTION_NAME = "process";

        DbModifyingAggregationServiceReportingPluginScriptRunner(IJythonEvaluator evaluator) {
            super(evaluator);
        }

        @Override
        protected String getFunctionName() {
            return FUNCTION_NAME;
        }

        @Override
        public void process(IDataSetRegistrationTransactionV2 transaction, Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor tableBuilder) throws EvaluatorException {
            this.evaluator.evalFunction(FUNCTION_NAME, new Object[]{transaction, parameters, tableBuilder});
        }
    }

    private static class AggregationServiceReportingPluginScriptRunner
    extends AbstractAggregationServiceReportingPluginScriptRunner
    implements IAggregationServiceReportingPluginScriptRunner {
        private static final String FUNCTION_NAME = "aggregate";

        @Override
        protected String getFunctionName() {
            return FUNCTION_NAME;
        }

        AggregationServiceReportingPluginScriptRunner(IJythonEvaluator evaluator) {
            super(evaluator);
        }

        @Override
        public void aggregate(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor tableBuilder) throws EvaluatorException {
            this.evaluator.evalFunction(FUNCTION_NAME, new Object[]{parameters, tableBuilder});
        }
    }

    private static abstract class AbstractAggregationServiceReportingPluginScriptRunner {
        final IJythonEvaluator evaluator;

        protected abstract String getFunctionName();

        public AbstractAggregationServiceReportingPluginScriptRunner(IJythonEvaluator evaluator) {
            this.evaluator = evaluator;
            if (!evaluator.hasFunction(this.getFunctionName())) {
                throw new EvaluatorException("Function '" + this.getFunctionName() + "' was not defined in the reporting plugin script");
            }
        }

        public void releaseResources() {
            this.evaluator.releaseResources();
        }
    }

    private static final class DataSetContentProvider
    implements IDataSetContentProvider,
    IReleasable {
        private final IHierarchicalContentProvider contentProvider;
        private final Map<String, IHierarchicalContent> contents = new HashMap<String, IHierarchicalContent>();

        public DataSetContentProvider(IHierarchicalContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        @Override
        public IHierarchicalContent getContent(String dataSetCode) {
            IHierarchicalContent content = this.contents.get(dataSetCode);
            if (content == null) {
                content = this.contentProvider.asContent(dataSetCode);
                this.contents.put(dataSetCode, content);
            }
            return content;
        }

        public void release() {
            for (IHierarchicalContent content : this.contents.values()) {
                content.close();
            }
        }
    }
}

