/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractFileTableReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.TableCellUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractDataMergingReportingPlugin
extends AbstractFileTableReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String FILE_INCLUDE_PATTERN = "file-include-pattern";
    private static final String FILE_EXCLUDE_PATTERN = "file-exclude-pattern";
    public static final String DEFAULT_EXCLUDED_FILE_NAMES_PATTERN = ".*\\.tsv";
    private final String excludePattern;
    private final String includePatternOrNull;

    protected AbstractDataMergingReportingPlugin(Properties properties, File storeRoot) {
        this(properties, storeRoot, '\t');
    }

    protected AbstractDataMergingReportingPlugin(Properties properties, File storeRoot, char defaultSeparator) {
        super(properties, storeRoot, defaultSeparator);
        String excludePatternOrNull = properties.getProperty(FILE_EXCLUDE_PATTERN);
        this.excludePattern = excludePatternOrNull == null ? DEFAULT_EXCLUDED_FILE_NAMES_PATTERN : excludePatternOrNull;
        this.includePatternOrNull = properties.getProperty(FILE_INCLUDE_PATTERN);
    }

    protected String[] getHeaderTitles(DatasetDescription dataset, IDataSetDirectoryProvider dirProvider) {
        File dir = this.getDataSubDir(dirProvider, dataset);
        DatasetFileLines lines = this.loadFromDirectory(dataset, dir);
        return lines.getHeaderLabels();
    }

    protected static void addDataRows(SimpleTableModelBuilder builder, DatasetDescription dataset, DatasetFileLines lines, boolean addFileNameColumn) {
        String datasetCode = dataset.getDataSetCode();
        String fileNameOrNull = addFileNameColumn ? lines.getFile().getName() : null;
        for (String[] dataTokens : lines.getDataLines()) {
            AbstractDataMergingReportingPlugin.addDataRow(builder, datasetCode, dataTokens, fileNameOrNull);
        }
    }

    protected static void addDataRow(SimpleTableModelBuilder builder, String datasetCode, String[] dataTokens, String fileNameOrNull) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(new StringTableCell(datasetCode));
        if (fileNameOrNull != null) {
            row.add(new StringTableCell(fileNameOrNull));
        }
        for (String token : dataTokens) {
            row.add(TableCellUtil.createTableCell((String)token));
        }
        builder.addRow(row);
    }

    protected DatasetFileLines loadFromDirectory(DatasetDescription dataset, File dir) throws ParserException, ParsingException, IllegalArgumentException, IOExceptionUnchecked {
        List<File> datasetFilesToMerge = this.findMatchingFiles(dataset, dir);
        if (datasetFilesToMerge.size() != 1) {
            throw UserFailureException.fromTemplate((String)"Directory with Data Set '%s' data ('%s') should contain exactly 1 file with data but %s files were found.", (Object[])new Object[]{dataset.getDataSetCode(), dir.getAbsolutePath(), datasetFilesToMerge.size()});
        }
        return this.loadFromFile(dataset, datasetFilesToMerge.get(0));
    }

    protected List<File> findMatchingFiles(DatasetDescription dataset, File dir) throws IllegalArgumentException, IOExceptionUnchecked {
        assert (dir != null) : "Given file must not be null";
        assert (dir.isDirectory()) : "Given file '" + dir.getAbsolutePath() + "' is not a directory.";
        File[] datasetFiles = FileUtilities.listFiles((File)dir);
        ArrayList<File> matchingFiles = new ArrayList<File>();
        for (File datasetFile : datasetFiles) {
            if (datasetFile.isDirectory()) {
                List<File> matched = this.findMatchingFiles(dataset, datasetFile);
                matchingFiles.addAll(matched);
                continue;
            }
            if (this.isFileExcluded(datasetFile)) continue;
            matchingFiles.add(datasetFile);
        }
        return matchingFiles;
    }

    protected boolean isFileExcluded(File file) {
        if (this.includePatternOrNull != null) {
            return !file.getName().matches(this.includePatternOrNull);
        }
        return file.getName().matches(this.excludePattern);
    }
}

