/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDatastorePlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DssLinkTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractDssLinkReportingPlugin
extends AbstractDatastorePlugin
implements IReportingPluginTask {
    private static final String DATA_SET_HEADER = "Data Set";
    private static final long serialVersionUID = 1L;

    protected AbstractDssLinkReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public ReportingPluginType getReportingPluginType() {
        return ReportingPluginType.DSS_LINK;
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader(DATA_SET_HEADER);
        for (DatasetDescription dataSet : datasets) {
            IRowBuilder rowBuilder = builder.addRow();
            LinkModel linkModel = this.createLink(dataSet);
            String text = dataSet.getDataSetCode();
            rowBuilder.setCell(DATA_SET_HEADER, (ISerializableComparable)new DssLinkTableCell(text, linkModel));
        }
        return builder.getTableModel();
    }

    @Override
    public TableModel createAggregationReport(Map<String, Object> parameters, DataSetProcessingContext context) {
        throw new IllegalArgumentException("The method createAggregationReport is not supported by DSS_LINK tasks");
    }
}

