/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CodeAndLabelUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ExcelFileReader;
import ch.systemsx.cisd.openbis.generic.shared.basic.TableCellUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractFileTableReportingPlugin
extends AbstractTableModelReportingPlugin {
    protected static final char TAB_SEPARATOR = '\t';
    protected static final char SEMICOLON_SEPARATOR = ';';
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR_PROPERTY_KEY = "separator";
    public static final String IGNORE_COMMENTS_PROPERTY_KEY = "ignore-comments";
    public static final String IGNORE_TRAILING_EMPTY_CELLS_PROPERTY_KEY = "ignore-trailing-empty-cells";
    public static final String EXCEL_SHEET_PROPERTY_KEY = "excel-sheet";
    private static final String defaultExcelSheet = "0";
    private static final char COMMENT = '#';
    private final char separator;
    private final boolean ignoreComments;
    private final boolean ignoreTrailingEmptyCells;
    private final String excelSheet;

    protected AbstractFileTableReportingPlugin(Properties properties, File storeRoot, char defaultSeparator) {
        super(properties, storeRoot);
        this.separator = PropertyUtils.getChar((Properties)properties, (String)SEPARATOR_PROPERTY_KEY, (char)defaultSeparator);
        this.ignoreComments = PropertyUtils.getBoolean((Properties)properties, (String)IGNORE_COMMENTS_PROPERTY_KEY, (boolean)true);
        this.ignoreTrailingEmptyCells = PropertyUtils.getBoolean((Properties)properties, (String)IGNORE_TRAILING_EMPTY_CELLS_PROPERTY_KEY, (boolean)false);
        this.excelSheet = PropertyUtils.getProperty((Properties)properties, (String)EXCEL_SHEET_PROPERTY_KEY, (String)defaultExcelSheet);
    }

    protected DatasetFileLines loadFromFile(DatasetDescription dataset, File file) throws ParserException, ParsingException, IllegalArgumentException, IOExceptionUnchecked {
        assert (file != null) : "Given file must not be null";
        assert (file.isFile()) : "Given file '" + file.getAbsolutePath() + "' is not a file.";
        if (ExcelFileReader.isExcelFile(file)) {
            try {
                Workbook workbook = ExcelFileReader.getExcelWorkbook(file);
                ExcelFileReader reader2 = new ExcelFileReader(workbook, this.ignoreComments);
                return this.load(dataset, reader2, file);
            }
            catch (IOException ex) {
                throw new IOExceptionUnchecked(ex);
            }
        }
        try (CsvReader reader = null;){
            reader = AbstractFileTableReportingPlugin.readFile(file, this.ignoreComments, this.separator);
            DatasetFileLines reader2 = this.load(dataset, reader, file);
            return reader2;
        }
    }

    private DatasetFileLines load(DatasetDescription dataset, ExcelFileReader reader, File file) throws IOException {
        assert (reader != null) : "Unspecified reader";
        List<String[]> lines = null;
        try {
            int index = Integer.parseInt(this.excelSheet);
            lines = reader.readLines(index);
        }
        catch (NumberFormatException ex) {
            lines = reader.readLines(this.excelSheet);
        }
        return new DatasetFileLines(file, dataset.getDataSetCode(), lines, this.ignoreTrailingEmptyCells);
    }

    private static CsvReader readFile(File file, boolean ignoreComments, char separator) throws IOException {
        if (!file.isFile()) {
            throw new UserFailureException(file + " does not exist or is not a file.");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        CsvReader csvReader = new CsvReader((InputStream)fileInputStream, Charset.defaultCharset());
        csvReader.setDelimiter(separator);
        csvReader.setSkipEmptyRecords(true);
        if (ignoreComments) {
            csvReader.setUseComments(true);
            csvReader.setComment('#');
        }
        return csvReader;
    }

    protected DatasetFileLines load(DatasetDescription dataset, CsvReader reader, File file) throws ParserException, ParsingException, IllegalArgumentException, IOException {
        assert (reader != null) : "Unspecified reader";
        ArrayList<String[]> lines = new ArrayList<String[]>();
        while (reader.readRecord()) {
            lines.add(reader.getValues());
        }
        return new DatasetFileLines(file, dataset.getDataSetCode(), lines, this.ignoreTrailingEmptyCells);
    }

    protected TableModel createTableModel(DatasetFileLines lines) {
        SimpleTableModelBuilder tableBuilder = new SimpleTableModelBuilder();
        for (String title : lines.getHeaderLabels()) {
            CodeAndLabel codeAndTitle = CodeAndLabelUtil.create(title);
            tableBuilder.addHeader(codeAndTitle.getLabel(), codeAndTitle.getCode());
        }
        for (String[] line : lines.getDataLines()) {
            ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
            for (String token : line) {
                row.add(TableCellUtil.createTableCell((String)token));
            }
            tableBuilder.addRow(row);
        }
        return tableBuilder.getTableModel();
    }

    protected static TableModel createTransposedTableModel(DatasetFileLines lines) {
        int c;
        int columns = lines.getHeaderLabels().length;
        int rows = lines.getDataLines().size() + 1;
        String[][] all = new String[columns][rows];
        for (int r = 0; r < rows; ++r) {
            for (c = 0; c < columns; ++c) {
                all[c][r] = r == 0 ? lines.getHeaderLabels()[c] : lines.getDataLines().get(r - 1)[c];
            }
        }
        SimpleTableModelBuilder tableBuilder = new SimpleTableModelBuilder();
        for (int r = 0; r < rows; ++r) {
            tableBuilder.addHeader(all[0][r]);
        }
        for (c = 1; c < columns; ++c) {
            ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
            for (int r = 0; r < rows; ++r) {
                row.add(TableCellUtil.createTableCell((String)all[c][r]));
            }
            tableBuilder.addRow(row);
        }
        return tableBuilder.getTableModel();
    }
}

