/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderFlags;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

abstract class AbstractPackageManager
implements IPackageManager {
    private transient IHierarchicalContentProvider contentProvider;
    private transient IDataSetDirectoryProvider directoryProvider;

    AbstractPackageManager() {
    }

    @Override
    public void create(File packageFile, AbstractExternalData dataSet) {
        this.create(packageFile, Collections.singletonList(dataSet), false);
    }

    @Override
    public void create(File packageFile, List<AbstractExternalData> dataSets) {
        this.create(packageFile, dataSets, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(File packageFile, List<AbstractExternalData> dataSets, boolean withPathPrefix) {
        try (AbstractDataSetPackager packager = null;){
            DataSetExistenceChecker existenceChecker = new DataSetExistenceChecker(this.getDirectoryProvider(), TimingParameters.create((Properties)new Properties()));
            packager = this.createPackager(packageFile, existenceChecker);
            for (AbstractExternalData dataSet : dataSets) {
                packager.addDataSetTo(withPathPrefix ? dataSet.getCode() + "/" : "", dataSet);
            }
        }
    }

    protected abstract AbstractDataSetPackager createPackager(File var1, DataSetExistenceChecker var2);

    protected IHierarchicalContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.contentProvider;
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        if (this.directoryProvider == null) {
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        return this.directoryProvider;
    }

    protected List<H5FolderFlags> extractH5FolderFlags(List<DatasetDescription> dataSets) {
        ArrayList<H5FolderFlags> result = new ArrayList<H5FolderFlags>();
        for (DatasetDescription dataSet : dataSets) {
            result.add(new H5FolderFlags(dataSet.getDataSetCode(), dataSet.isH5Folders(), dataSet.isH5arFolders()));
        }
        return result;
    }
}

