/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDatastorePlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public abstract class AggregationService
extends AbstractDatastorePlugin
implements IReportingPluginTask {
    private static final long serialVersionUID = 1L;

    protected AggregationService(Properties properties, File storeRoot) {
        this(properties, storeRoot, null);
    }

    protected AggregationService(Properties properties, File storeRoot, String subDirectory) {
        super(properties, storeRoot, subDirectory);
    }

    @Override
    public ReportingPluginType getReportingPluginType() {
        return ReportingPluginType.AGGREGATION_TABLE_MODEL;
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        throw this.createException();
    }

    @Override
    public LinkModel createLink(DatasetDescription dataset) {
        throw this.createException();
    }

    private IllegalArgumentException createException() {
        return new IllegalArgumentException("The method createReport is not supported by " + this.getReportingPluginType() + " tasks");
    }

    protected void logInvocationError(Map<String, Object> parameters, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error producing aggregation report\n");
        sb.append("Class: ");
        sb.append(this.getClass().getName());
        sb.append("\n");
        sb.append("Parameters: ");
        sb.append(parameters.keySet());
        operationLog.error((Object)sb.toString(), e);
    }

    protected TableModel errorTableModel(Map<String, Object> parameters, Throwable e) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader("Parameters");
        builder.addHeader("Error");
        IRowBuilder row = builder.addRow();
        row.setCell("Parameters", parameters.toString());
        String message = e.getMessage();
        row.setCell("Error", StringUtils.isBlank((CharSequence)message) ? e.toString() : message);
        return builder.getTableModel();
    }
}

