/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.PhysicalData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.server.sharedapi.v3.json.GenericObjectMapper;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AggregationService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ArchivingAggregationService
extends AggregationService {
    static final String METHOD_KEY = "method";
    static final String ARGS_KEY = "args";
    static final String GET_ARCHIVING_INFO_METHOD = "getArchivingInfo";
    private static final long serialVersionUID = 1L;
    private IApplicationServerApi v3api;
    private IArchiverPlugin archiver;

    public ArchivingAggregationService(Properties properties, File storeRoot) {
        this(properties, storeRoot, null, null);
    }

    ArchivingAggregationService(Properties properties, File storeRoot, IApplicationServerApi v3api, IArchiverPlugin archiver) {
        super(properties, storeRoot);
        this.v3api = v3api;
        this.archiver = archiver;
    }

    @Override
    public TableModel createAggregationReport(Map<String, Object> parameters, DataSetProcessingContext context) {
        try {
            Object method = parameters.get(METHOD_KEY);
            List<String> arguments = this.getArguments(parameters);
            if (GET_ARCHIVING_INFO_METHOD.equals(method)) {
                return this.getArchivingInfo(context.trySessionToken(), arguments);
            }
            throw new UserFailureException("Unknown method '" + method + "'.");
        }
        catch (Throwable e) {
            this.logInvocationError(parameters, e);
            return this.errorTableModel(parameters, e);
        }
    }

    private TableModel getArchivingInfo(String sessionToken, List<String> dataSetCodes) {
        Map<String, Set<String>> bundlesByDataSetCode = this.getBundles(dataSetCodes);
        Set<String> allDataSets = this.mergeAllBundles(bundlesByDataSetCode);
        Map<String, Long> dataSetSizes = this.getDataSetSizes(sessionToken, allDataSets);
        Map<String, Long> bundleSizes = this.getBundleSizes(bundlesByDataSetCode, dataSetSizes);
        long totalSize = this.getTotalSize(allDataSets, dataSetSizes);
        TreeMap<String, Serializable> infos = new TreeMap<String, Serializable>();
        infos.put("total size", Long.valueOf(totalSize));
        for (Map.Entry<String, Set<String>> entry : bundlesByDataSetCode.entrySet()) {
            TreeMap<String, Object> info = new TreeMap<String, Object>();
            String dataSetCode = entry.getKey();
            info.put("size", this.getDataSetSizeOr0IfUnknown(dataSetSizes, dataSetCode));
            Set<String> bundleDataSets = entry.getValue();
            info.put("bundleId", this.getBundleId(bundleDataSets));
            HashSet<String> notDeletedDataSets = new HashSet<String>(bundleDataSets);
            notDeletedDataSets.retainAll(dataSetSizes.keySet());
            info.put("numberOfDataSets", notDeletedDataSets.size());
            info.put("bundleSize", this.getDataSetSizeOr0IfUnknown(bundleSizes, dataSetCode));
            infos.put(dataSetCode, info);
        }
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader("STATUS");
        builder.addHeader("MESSAGE");
        builder.addHeader("RESULT");
        IRowBuilder row = builder.addRow();
        row.setCell("STATUS", "OK");
        row.setCell("MESSAGE", "Operation Successful");
        GenericObjectMapper objectMapper = new GenericObjectMapper();
        try {
            String jsonValue = objectMapper.writeValueAsString(infos);
            row.setCell("RESULT", jsonValue);
        }
        catch (JsonProcessingException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
        return builder.getTableModel();
    }

    private Map<String, Set<String>> getBundles(List<String> dataSetCodes) {
        TreeMap<String, Set<String>> results = new TreeMap<String, Set<String>>();
        for (String dataSetCode : new HashSet<String>(dataSetCodes)) {
            results.put(dataSetCode, new TreeSet<String>(this.getArchiver().getDataSetCodesForUnarchiving(Arrays.asList(dataSetCode))));
        }
        return results;
    }

    private Set<String> mergeAllBundles(Map<String, Set<String>> bundles) {
        TreeSet<String> result = new TreeSet<String>();
        for (Set<String> set : bundles.values()) {
            result.addAll(set);
        }
        return result;
    }

    private Map<String, Long> getDataSetSizes(String sessionToken, Collection<String> dataSetCodes) {
        List ids = dataSetCodes.stream().map(DataSetPermId::new).collect(Collectors.toList());
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withPhysicalData();
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        for (DataSet dataSet : this.getv3api().getDataSets(sessionToken, ids, fetchOptions).values()) {
            PhysicalData physicalData = dataSet.getPhysicalData();
            if (physicalData == null) {
                throw new UserFailureException("Data set " + dataSet.getCode() + " isn't a physical data set.");
            }
            Long size = physicalData.getSize();
            if (size == null) {
                throw new UserFailureException("Physical data set " + dataSet.getCode() + " has unknown size.");
            }
            result.put(dataSet.getCode(), size);
        }
        return result;
    }

    private Map<String, Long> getBundleSizes(Map<String, Set<String>> bundlesByDataSetCode, Map<String, Long> dataSetSizes) {
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        for (Map.Entry<String, Set<String>> entry : bundlesByDataSetCode.entrySet()) {
            long sum = 0L;
            for (String dataSetCode : entry.getValue()) {
                sum += this.getDataSetSizeOr0IfUnknown(dataSetSizes, dataSetCode);
            }
            result.put(entry.getKey(), sum);
        }
        return result;
    }

    private long getTotalSize(Set<String> allDataSets, Map<String, Long> dataSetSizes) {
        long sum = 0L;
        for (String dataSetCode : allDataSets) {
            sum += this.getDataSetSizeOr0IfUnknown(dataSetSizes, dataSetCode);
        }
        return sum;
    }

    private long getDataSetSizeOr0IfUnknown(Map<String, Long> dataSetSizes, String dataSetCode) {
        Long size = dataSetSizes.get(dataSetCode);
        return size != null ? size : 0L;
    }

    private String getBundleId(Set<String> bundleDataSets) {
        ArrayList<String> sortedDataSets = new ArrayList<String>(bundleDataSets);
        Collections.sort(sortedDataSets);
        return (String)sortedDataSets.get(0);
    }

    private List<String> getArguments(Map<String, Object> parameters) {
        ArrayList<String> result = new ArrayList<String>();
        Object args = parameters.get(ARGS_KEY);
        if (args instanceof String) {
            String[] splitted;
            for (String string : splitted = ((String)args).split(",")) {
                String arg = string.trim();
                if (!StringUtils.isNotBlank((CharSequence)arg)) continue;
                result.add(arg);
            }
        }
        return result;
    }

    private IArchiverPlugin getArchiver() {
        if (this.archiver == null) {
            IDataStoreServiceInternal dataStoreService = ServiceProvider.getDataStoreService();
            this.archiver = dataStoreService.getArchiverPlugin();
        }
        return this.archiver;
    }

    private IApplicationServerApi getv3api() {
        if (this.v3api == null) {
            this.v3api = ServiceProvider.getV3ApplicationService();
        }
        return this.v3api;
    }
}

