/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.ITableModelTransformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class DecoratingTableModelReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String REPORTING_PLUGIN_KEY = "reporting-plugin";
    private static final String TRANSFORMATION_KEY = "transformation";
    private final IReportingPluginTask reportingPlugin;
    private ITableModelTransformation transformation;

    public DecoratingTableModelReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        ExtendedProperties pluginProperties = ExtendedProperties.getSubset((Properties)properties, (String)"reporting-plugin.", (boolean)true);
        this.reportingPlugin = this.createReportingPlugin((Properties)pluginProperties);
        if (!this.reportingPlugin.getReportingPluginType().equals((Object)ReportingPluginType.TABLE_MODEL)) {
            throw new ConfigurationFailureException("Only reporting plugins of type table model can be decorated.");
        }
        ExtendedProperties transformationProperties = ExtendedProperties.getSubset((Properties)properties, (String)"transformation.", (boolean)true);
        this.transformation = this.createTransformation((Properties)transformationProperties);
    }

    private IReportingPluginTask createReportingPlugin(Properties pluginProperties) {
        String className = PropertyUtils.getMandatoryProperty((Properties)pluginProperties, (String)"class");
        try {
            return (IReportingPluginTask)ClassUtils.create(IReportingPluginTask.class, (String)className, (Object[])new Object[]{pluginProperties, this.storeRoot});
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot create the plugin class '" + className + "'", (Throwable)CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }

    private ITableModelTransformation createTransformation(Properties transformationProperties) {
        String className = PropertyUtils.getMandatoryProperty((Properties)transformationProperties, (String)"class");
        try {
            return (ITableModelTransformation)ClassUtils.create(ITableModelTransformation.class, (String)className, (Object[])new Object[]{transformationProperties});
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot create the transformation class '" + className + "'", (Throwable)CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        TableModel report = this.reportingPlugin.createReport(datasets, context);
        return this.transformation.transform(report);
    }
}

