/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.ITableModelTransformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EntityLinksDecorator
implements ITableModelTransformation {
    private static final String LINK_COLUMNS_KEY = "link-columns";
    private static final String ENTITY_KIND_KEY = "entity-kind";
    private final Map<String, IEntityTableCellTranslation> translations = new HashMap<String, IEntityTableCellTranslation>();

    public EntityLinksDecorator(Properties properties) {
        PropertyParametersUtil.SectionProperties[] sections;
        for (PropertyParametersUtil.SectionProperties section : sections = PropertyParametersUtil.extractSectionProperties((Properties)properties, (String)LINK_COLUMNS_KEY, (boolean)false)) {
            Properties sectionProperties = section.getProperties();
            EntityTableCellTranslationFactory factory = this.getEntityTableCellTranslationFactory(sectionProperties);
            this.translations.put(section.getKey(), factory.create(sectionProperties));
        }
    }

    private EntityTableCellTranslationFactory getEntityTableCellTranslationFactory(Properties sectionProperties) {
        EntityTableCellTranslationFactory factory;
        String ek = PropertyUtils.getMandatoryProperty((Properties)sectionProperties, (String)ENTITY_KIND_KEY);
        try {
            factory = EntityTableCellTranslationFactory.valueOf(ek);
            factory.assertValidProperties(sectionProperties);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationFailureException("Unknown entity kind: " + ek);
        }
        return factory;
    }

    public TableModel transform(TableModel tableModel) {
        class TranslationAndIndex {
            int index;
            IEntityTableCellTranslation translation;

            TranslationAndIndex(int index, IEntityTableCellTranslation translation) {
                this.index = index;
                this.translation = translation;
            }
        }
        ArrayList<TranslationAndIndex> translationsAndIndices = new ArrayList<TranslationAndIndex>();
        List headers = tableModel.getHeader();
        for (int i = 0; i < headers.size(); ++i) {
            TableModelColumnHeader header = (TableModelColumnHeader)headers.get(i);
            IEntityTableCellTranslation translation = this.translations.get(header.getId());
            if (translation == null) continue;
            translationsAndIndices.add(new TranslationAndIndex(i, translation));
            header.setEntityKind(translation.getEntityKind());
        }
        List rows = tableModel.getRows();
        for (TableModelRow row : rows) {
            List values = row.getValues();
            for (TranslationAndIndex generatorAndIndex : translationsAndIndices) {
                int index = generatorAndIndex.index;
                ISerializableComparable value = (ISerializableComparable)values.get(index);
                values.set(index, generatorAndIndex.translation.translation(value));
            }
        }
        return tableModel;
    }

    private static enum EntityTableCellTranslationFactory {
        MATERIAL{
            private static final String MATERIAL_TYPE_KEY = "material-type";

            @Override
            void assertValidProperties(Properties properties) {
                this.getMaterialType(properties);
            }

            @Override
            IEntityTableCellTranslation create(Properties properties) {
                final String materialType = this.getMaterialType(properties);
                return new IEntityTableCellTranslation(){

                    @Override
                    public ISerializableComparable translation(ISerializableComparable value) {
                        String materialCode = value.toString();
                        EntityTableCell entityTableCell = new EntityTableCell(EntityKind.MATERIAL, MaterialIdentifier.print((String)materialCode, (String)materialType));
                        entityTableCell.setLinkText(materialCode);
                        return entityTableCell;
                    }

                    @Override
                    public EntityKind getEntityKind() {
                        return EntityKind.MATERIAL;
                    }
                };
            }

            String getMaterialType(Properties properties) {
                return PropertyUtils.getMandatoryProperty((Properties)properties, (String)MATERIAL_TYPE_KEY).trim();
            }
        }
        ,
        SAMPLE{
            private static final String DEFAULT_SPACE_KEY = "default-space";

            @Override
            IEntityTableCellTranslation create(Properties properties) {
                String property = properties.getProperty(DEFAULT_SPACE_KEY);
                final String defaultSpace = property == null ? null : "/" + property.trim();
                return new IEntityTableCellTranslation(){

                    @Override
                    public ISerializableComparable translation(ISerializableComparable value) {
                        String identifier = SampleIdentifierFactory.parse((String)value.toString(), (String)defaultSpace).toString();
                        EntityTableCell entityTableCell = new EntityTableCell(EntityKind.SAMPLE, "", identifier);
                        entityTableCell.setLinkText(value.toString());
                        return entityTableCell;
                    }

                    @Override
                    public EntityKind getEntityKind() {
                        return EntityKind.SAMPLE;
                    }
                };
            }
        };


        void assertValidProperties(Properties properties) {
        }

        abstract IEntityTableCellTranslation create(Properties var1);
    }

    private static interface IEntityTableCellTranslation {
        public ISerializableComparable translation(ISerializableComparable var1);

        public EntityKind getEntityKind();
    }
}

