/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDssLinkReportingPlugin;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;

public class GenericDssLinkReportingPlugin
extends AbstractDssLinkReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String MAIN_DATA_SET_PATH = "mdsPath";
    private static final String MAIN_DATA_SET_PATTERN = "mdsPattern";
    private static final String FORCE_AUTO_RESOLVE = "forceAutoResolve";
    private static final String SESSION_ID = "sessionID";
    private static final String DOWNLOAD_URL = "download-url";
    private static final String DATA_SET_REGEX = "data-set-regex";
    private static final String DATA_SET_PATH = "data-set-path";
    private final String downloadUrl;
    private final String regexOrNull;
    private final String pathOrNull;

    public GenericDssLinkReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.downloadUrl = PropertyUtils.getProperty((Properties)properties, (String)DOWNLOAD_URL, (String)"");
        this.regexOrNull = PropertyUtils.getProperty((Properties)properties, (String)DATA_SET_REGEX);
        this.pathOrNull = PropertyUtils.getProperty((Properties)properties, (String)DATA_SET_PATH);
    }

    public LinkModel getDataSetLinkModel(DatasetDescription dataSet) {
        return this.getDataSetLinkModel(dataSet, null);
    }

    public LinkModel getDataSetLinkModel(DatasetDescription dataSet, String sessionIdOrNull) {
        LinkModel linkModel = new LinkModel();
        linkModel.setSchemeAndDomain(this.downloadUrl);
        linkModel.setPath("datastore_server/" + dataSet.getDataSetCode());
        ArrayList<LinkModel.LinkParameter> parameters = new ArrayList<LinkModel.LinkParameter>();
        parameters.add(new LinkModel.LinkParameter(FORCE_AUTO_RESOLVE, Boolean.TRUE.toString()));
        if (this.regexOrNull != null) {
            parameters.add(new LinkModel.LinkParameter(MAIN_DATA_SET_PATTERN, this.regexOrNull));
        }
        if (this.pathOrNull != null) {
            parameters.add(new LinkModel.LinkParameter(MAIN_DATA_SET_PATH, this.pathOrNull));
        }
        if (sessionIdOrNull != null) {
            parameters.add(new LinkModel.LinkParameter(SESSION_ID, sessionIdOrNull));
        }
        linkModel.setParameters(parameters);
        return linkModel;
    }

    @Override
    public LinkModel createLink(DatasetDescription dataSet) {
        return this.getDataSetLinkModel(dataSet);
    }
}

