/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.highwatermark.HighwaterMarkWatcher;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IStatusChecker;
import java.io.File;
import java.io.Serializable;

public class HighWaterMarkChecker
implements IStatusChecker,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long highWaterMark;
    private final File highWaterMarkPath;

    public HighWaterMarkChecker(long archiveHighWaterMark, File archiveHighWaterMarkPath) {
        this.highWaterMark = archiveHighWaterMark;
        this.highWaterMarkPath = archiveHighWaterMarkPath;
    }

    @Override
    public Status check(int numberOfItems) {
        HighwaterMarkWatcher w = new HighwaterMarkWatcher(this.highWaterMark * (long)numberOfItems);
        HighwaterMarkWatcher.HighwaterMarkState state = w.getHighwaterMarkState(new HostAwareFile(this.highWaterMarkPath));
        if (HighwaterMarkWatcher.isBelow((HighwaterMarkWatcher.HighwaterMarkState)state)) {
            String canonicalPath = this.highWaterMarkPath.getPath();
            String mark = HighwaterMarkWatcher.displayKilobyteValue((long)state.getHighwaterMark());
            String space = HighwaterMarkWatcher.displayKilobyteValue((long)state.getFreeSpace());
            String message = String.format("Free space on '%s': %s, highwater mark: %s.", canonicalPath, space, mark);
            return Status.createError((String)message);
        }
        return Status.OK;
    }
}

