/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDataMergingReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MergedRowDataReportingPlugin
extends AbstractDataMergingReportingPlugin {
    private static final long serialVersionUID = 1L;

    public MergedRowDataReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        builder.addHeader("Data Set Code");
        if (!datasets.isEmpty()) {
            IDataSetDirectoryProvider directoryProvider = context.getDirectoryProvider();
            DatasetDescription firstDataset = datasets.get(0);
            Object[] titles = this.getHeaderTitles(firstDataset, directoryProvider);
            for (String string : titles) {
                builder.addHeader(string);
            }
            for (DatasetDescription dataset : datasets) {
                File dir;
                DatasetFileLines datasetFileLines = this.loadFromDirectory(dataset, dir = this.getDataSubDir(directoryProvider, dataset));
                if (!Arrays.equals(titles, datasetFileLines.getHeaderLabels())) {
                    throw UserFailureException.fromTemplate((String)"All Data Set files should have the same headers, but file header of '%s': \n\t '%s' is different than file header of '%s': \n\t '%s'.", (Object[])new Object[]{firstDataset.getDataSetCode(), StringUtils.join((Object[])titles, (String)"\t"), dataset.getDataSetCode(), StringUtils.join((Object[])datasetFileLines.getHeaderLabels(), (String)"\t")});
                }
                MergedRowDataReportingPlugin.addDataRows(builder, dataset, datasetFileLines, false);
            }
        }
        return builder.getTableModel();
    }
}

