/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncCopier;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class RsyncArchiveCopierFactory
implements Serializable,
IPathCopierFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public IPathCopier create(File rsyncExecutable, File sshExecutableOrNull, long timeoutInMillis, List<String> additionalCmdLineFlagsOrNull) {
        ArrayList<String> additionalCmdLineFlags = new ArrayList<String>(Arrays.asList("--archive", "--delete", "--inplace", "--checksum", this.getTimeoutParameter(timeoutInMillis)));
        if (additionalCmdLineFlagsOrNull != null) {
            additionalCmdLineFlags.addAll(additionalCmdLineFlagsOrNull);
        }
        return new RsyncCopier(rsyncExecutable, sshExecutableOrNull, additionalCmdLineFlags.toArray(new String[0]));
    }

    private String getTimeoutParameter(long timeoutInMillis) {
        long timeoutInSeconds = timeoutInMillis / 1000L;
        return "--timeout=" + timeoutInSeconds;
    }
}

