/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.Hdf5AwareHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractArchiverProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.DataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManagerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiveCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.SshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class RsyncArchiver
extends AbstractArchiverProcessingPlugin {
    @Private
    static final String ONLY_MARK_AS_DELETED_KEY = "only-mark-as-deleted";
    @Private
    static final String STAGING_FOLDER = "archive-staging";
    @Private
    static final String VERIFY_CHECKSUMS_KEY = "verify-checksums";
    private static final long serialVersionUID = 1L;
    private static final Comparator<IHierarchicalContentNode> NODE_COMPARATOR = new Comparator<IHierarchicalContentNode>(){

        @Override
        public int compare(IHierarchicalContentNode n1, IHierarchicalContentNode n2) {
            return n1.getName().compareTo(n2.getName());
        }
    };
    private transient IDataSetFileOperationsManager fileOperationsManager;
    private final IDataSetFileOperationsManagerFactory fileOperationsManagerFactory;
    private final DeleteAction deleteAction;
    private final ChecksumVerificationCondition checksumVerificationCondition;

    public IDataSetFileOperationsManager getFileOperationsManager() {
        if (this.fileOperationsManager == null) {
            this.fileOperationsManager = this.fileOperationsManagerFactory.create();
        }
        return this.fileOperationsManager;
    }

    public RsyncArchiver(Properties properties, File storeRoot) {
        this(properties, storeRoot, new DataSetFileOperationsManagerFactory(properties));
    }

    protected RsyncArchiver(Properties properties, File storeRoot, IDataSetFileOperationsManagerFactory fileOperationsManagerFactory) {
        this(properties, storeRoot, fileOperationsManagerFactory, PropertyUtils.getBoolean((Properties)properties, (String)ONLY_MARK_AS_DELETED_KEY, (boolean)true) ? DeleteAction.MARK_AS_DELETED : DeleteAction.DELETE, PropertyUtils.getBoolean((Properties)properties, (String)VERIFY_CHECKSUMS_KEY, (boolean)true) ? ChecksumVerificationCondition.YES : ChecksumVerificationCondition.NO);
    }

    public RsyncArchiver(Properties properties, File storeRoot, IDataSetFileOperationsManagerFactory fileOperationsManagerFactory, DeleteAction deleteAction, ChecksumVerificationCondition checksumVerificationCondition) {
        super(properties, storeRoot, null, null);
        this.fileOperationsManagerFactory = fileOperationsManagerFactory;
        this.deleteAction = deleteAction;
        this.checksumVerificationCondition = checksumVerificationCondition;
    }

    private File getTempRoot() {
        File tempFolderProperty = this.getTemporaryFolder();
        if (tempFolderProperty != null) {
            return tempFolderProperty;
        }
        return this.storeRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doArchive(List<DatasetDescription> datasets, ArchiverTaskContext context, boolean removeFromDataStore) throws UserFailureException {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (DatasetDescription dataset : datasets) {
            File originalData = this.getDatasetDirectory(context, dataset);
            Status status = this.doArchive(dataset, originalData);
            String dataSetCode = dataset.getDataSetCode();
            if (status.isOK()) {
                IHierarchicalContent archivedContent;
                File temp;
                block12: {
                    IHierarchicalContent content = null;
                    temp = null;
                    archivedContent = null;
                    try {
                        content = context.getHierarchicalContentProvider().asContentWithoutModifyingAccessTimestamp(dataSetCode);
                        temp = new File(this.getTempRoot(), "archive-staging/" + dataSetCode);
                        temp.mkdirs();
                        if (this.getFileOperationsManager().isHosted()) {
                            this.getFileOperationsManager().retrieveFromDestination(temp, dataset);
                            Hdf5AwareHierarchicalContentFactory contentFactory = new Hdf5AwareHierarchicalContentFactory(dataset.isH5Folders(), dataset.isH5arFolders());
                            archivedContent = contentFactory.asHierarchicalContent(temp, null);
                        } else {
                            archivedContent = this.getFileOperationsManager().getAsHierarchicalContent(dataset);
                        }
                        IHierarchicalContentNode root = content.getRootNode();
                        IHierarchicalContentNode archivedRoot = archivedContent.getRootNode();
                        status = RsyncArchiver.checkHierarchySizeAndChecksums(root, "", archivedRoot, this.checksumVerificationCondition);
                        if (content == null) break block12;
                    }
                    catch (Throwable t) {
                        block13: {
                            try {
                                status = Status.createError((String)("Sanity check for data set " + dataSetCode + " failed: " + t));
                                if (content == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (content != null) {
                                    content.close();
                                }
                                if (archivedContent != null) {
                                    archivedContent.close();
                                }
                                FileUtils.deleteQuietly(temp);
                                throw throwable;
                            }
                            content.close();
                        }
                        if (archivedContent != null) {
                            archivedContent.close();
                        }
                        FileUtils.deleteQuietly((File)temp);
                    }
                    content.close();
                }
                if (archivedContent != null) {
                    archivedContent.close();
                }
                FileUtils.deleteQuietly((File)temp);
            }
            statuses.addResult(dataSetCode, status, AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        }
        return statuses;
    }

    private static String pathCombine(String part1, String part2) {
        if (part1.equals("")) {
            return part2;
        }
        if (part2.equals("")) {
            return part1;
        }
        return part1 + File.separator + part2;
    }

    public static Status checkHierarchySizeAndChecksums(IHierarchicalContentNode node, String originalNodeContext, IHierarchicalContentNode retrievedNode, ChecksumVerificationCondition checksumVerificationCondition) {
        boolean directoryOfRetrieved;
        String relativePathOfRetrieved;
        String relativePath = RsyncArchiver.pathCombine(originalNodeContext, node.getRelativePath());
        if (!relativePath.equals(relativePathOfRetrieved = retrievedNode.getRelativePath())) {
            return Status.createError((String)("Different paths: Path in the store is '" + relativePath + "' and in the archive '" + relativePathOfRetrieved + "'."));
        }
        boolean directory = node.isDirectory();
        if (directory != (directoryOfRetrieved = retrievedNode.isDirectory())) {
            return Status.createError((String)("The path '" + relativePath + "' should be in store and archive either both directories or files but not mixed: In the store it is a " + RsyncArchiver.render(directory) + " but in the archive it is a " + RsyncArchiver.render(directoryOfRetrieved) + "."));
        }
        if (directory) {
            int sizeOfRetrieved;
            List<IHierarchicalContentNode> childNodes = RsyncArchiver.getChildNodes(node);
            List<IHierarchicalContentNode> childNodesOfRetrieved = RsyncArchiver.getChildNodes(retrievedNode);
            int size = childNodes.size();
            if (size != (sizeOfRetrieved = childNodesOfRetrieved.size())) {
                return Status.createError((String)("The directory '" + relativePath + "' has in the store " + size + " files but " + sizeOfRetrieved + " in the archive."));
            }
            for (int i = 0; i < size; ++i) {
                Status status = RsyncArchiver.checkHierarchySizeAndChecksums(childNodes.get(i), originalNodeContext, childNodesOfRetrieved.get(i), checksumVerificationCondition);
                if (!status.isError()) continue;
                return status;
            }
        } else {
            long checksumOfRetrieved;
            long checksum;
            long fileLengthOfRetrieved;
            long fileLength = node.getFileLength();
            if (fileLength != (fileLengthOfRetrieved = retrievedNode.getFileLength())) {
                return Status.createError((String)("The file '" + relativePath + "' has in the store " + fileLength + " bytes but " + fileLengthOfRetrieved + " in the archive."));
            }
            if (checksumVerificationCondition.verifyChecksum(node) && (checksum = (long)node.getChecksumCRC32()) != (checksumOfRetrieved = (long)retrievedNode.getChecksumCRC32())) {
                return Status.createError((String)("The file '" + relativePath + "' has in the store the checksum " + RsyncArchiver.renderChecksum(checksum) + " but " + RsyncArchiver.renderChecksum(checksumOfRetrieved) + " in the archive."));
            }
        }
        return Status.OK;
    }

    private static List<IHierarchicalContentNode> getChildNodes(IHierarchicalContentNode node) {
        List childNodes = node.getChildNodes();
        Collections.sort(childNodes, NODE_COMPARATOR);
        return childNodes;
    }

    private static String render(boolean directory) {
        return directory ? "directory" : "file";
    }

    private static String renderChecksum(long checksum) {
        return String.format("%08X", checksum);
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doUnarchive(List<DatasetDescription> datasets, ArchiverTaskContext context) throws UserFailureException {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (DatasetDescription dataset : datasets) {
            context.getUnarchivingPreparation().prepareForUnarchiving(Collections.singletonList(dataset));
            File originalData = this.getDatasetDirectory(context, dataset);
            Status status = this.doUnarchive(dataset, originalData);
            statuses.addResult(dataset.getDataSetCode(), status, AbstractArchiverProcessingPlugin.Operation.UNARCHIVE);
        }
        return statuses;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> datasets) {
        return this.delete(datasets, this.deleteAction);
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses deletePermanentlyFromArchive(List<? extends IDatasetLocation> dataSets) {
        return this.delete(dataSets, DeleteAction.DELETE);
    }

    private AbstractArchiverProcessingPlugin.DatasetProcessingStatuses delete(List<? extends IDatasetLocation> datasets, DeleteAction action) {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (IDatasetLocation iDatasetLocation : datasets) {
            Status status = action.execute(this.getFileOperationsManager(), iDatasetLocation);
            statuses.addResult(iDatasetLocation.getDataSetCode(), status, action.getOperation());
        }
        return statuses;
    }

    @Override
    protected BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription dataset, ArchiverTaskContext context) {
        File originalData = this.getDatasetDirectory(context, dataset);
        return this.getFileOperationsManager().isSynchronizedWithDestination(originalData, dataset);
    }

    @Override
    protected BooleanStatus isDataSetPresentInArchive(DatasetDescription dataset) {
        return this.getFileOperationsManager().isPresentInDestination(dataset);
    }

    private Status doArchive(DatasetDescription dataset, File originalData) {
        return this.getFileOperationsManager().copyToDestination(originalData, dataset);
    }

    private Status doUnarchive(DatasetDescription dataset, File originalData) {
        return this.getFileOperationsManager().retrieveFromDestination(originalData, dataset);
    }

    private File getDatasetDirectory(ArchiverTaskContext context, DatasetDescription dataset) {
        return context.getDirectoryProvider().getDataSetDirectory((IDatasetLocation)dataset);
    }

    public static class DataSetFileOperationsManagerFactory
    implements IDataSetFileOperationsManagerFactory {
        private static final long serialVersionUID = 1L;
        private final Properties properties;

        public DataSetFileOperationsManagerFactory(Properties properties) {
            this.properties = properties;
        }

        @Override
        public IDataSetFileOperationsManager create() {
            return new DataSetFileOperationsManager(this.properties, new RsyncArchiveCopierFactory(), new SshCommandExecutorFactory());
        }
    }

    public static enum DeleteAction {
        DELETE(AbstractArchiverProcessingPlugin.Operation.DELETE_FROM_ARCHIVE){

            @Override
            public Status execute(IDataSetFileOperationsManager manager, IDatasetLocation dataSet) {
                return manager.deleteFromDestination(dataSet);
            }
        }
        ,
        MARK_AS_DELETED(AbstractArchiverProcessingPlugin.Operation.MARK_AS_DELETED){

            @Override
            public Status execute(IDataSetFileOperationsManager manager, IDatasetLocation dataSet) {
                return manager.markAsDeleted(dataSet);
            }
        };

        private final AbstractArchiverProcessingPlugin.Operation operation;

        private DeleteAction(AbstractArchiverProcessingPlugin.Operation operation) {
            this.operation = operation;
        }

        public AbstractArchiverProcessingPlugin.Operation getOperation() {
            return this.operation;
        }

        public abstract Status execute(IDataSetFileOperationsManager var1, IDatasetLocation var2);
    }

    public static enum ChecksumVerificationCondition {
        NO{

            @Override
            boolean verifyChecksum(IHierarchicalContentNode node) {
                return false;
            }
        }
        ,
        YES{

            @Override
            boolean verifyChecksum(IHierarchicalContentNode node) {
                return true;
            }
        }
        ,
        IF_AVAILABLE{

            @Override
            boolean verifyChecksum(IHierarchicalContentNode node) {
                return node.isChecksumCRC32Precalculated();
            }
        };


        abstract boolean verifyChecksum(IHierarchicalContentNode var1);
    }
}

