/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.AutoResolveUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractFileTableReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class TSVViewReportingPlugin
extends AbstractFileTableReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String TRANSPOSE_KEY = "transpose";
    private final boolean transpose;

    public TSVViewReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot, '\t');
        this.transpose = PropertyUtils.getBoolean((Properties)properties, (String)TRANSPOSE_KEY, (boolean)false);
    }

    @Override
    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        IHierarchicalContentNode fileToOpenOrNull;
        this.assureOnlyOneDataSetSelected(datasets);
        DatasetDescription dataset = datasets.get(0);
        IHierarchicalContent root = this.getDatasetDir(context.getHierarchicalContentProvider(), dataset);
        String pattern = this.properties.getProperty("data-set-regex");
        String path = this.properties.getProperty("data-set-path");
        if (pattern == null) {
            pattern = dataset.getMainDataSetPattern();
        }
        if (path == null) {
            path = dataset.getMainDataSetPath();
        }
        if ((fileToOpenOrNull = this.tryFindFileToOpen(pattern, path, root)) != null && !fileToOpenOrNull.isDirectory() && fileToOpenOrNull.exists()) {
            DatasetFileLines lines = this.loadFromFile(dataset, fileToOpenOrNull.getFile());
            return this.transpose ? TSVViewReportingPlugin.createTransposedTableModel(lines) : this.createTableModel(lines);
        }
        throw UserFailureException.fromTemplate((String)"Main TSV file could not be found.", (Object[])new Object[0]);
    }

    private IHierarchicalContentNode tryFindFileToOpen(String pattern, String path, IHierarchicalContent root) {
        List<IHierarchicalContentNode> patternMatchinFiles = AutoResolveUtils.findSomeMatchingFiles(root, path, pattern);
        IHierarchicalContentNode mainDataSetFile = null;
        if (patternMatchinFiles.size() == 1) {
            mainDataSetFile = patternMatchinFiles.get(0);
        }
        return mainDataSetFile;
    }

    private void assureOnlyOneDataSetSelected(List<DatasetDescription> datasets) {
        if (datasets.size() != 1) {
            throw UserFailureException.fromTemplate((String)"Chosen plugin works with exactly one data set. %s data sets selected.", (Object[])new Object[]{datasets.size()});
        }
    }
}

