/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.common.io.MonitoredIOStreamCopier;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderChecker;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderFlags;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;

class TarBasedPathInfoProvider
implements ISingleDataSetPathInfoProvider {
    private final File packageFile;
    private final int bufferSize;
    private final ISimpleLogger ioSpeedLogger;
    private Map<String, DataSetPathInfo> pathInfos;
    private Map<String, List<DataSetPathInfo>> pathInfoChildren;
    private List<H5FolderFlags> h5FolderFlags;

    TarBasedPathInfoProvider(File packageFile, List<H5FolderFlags> h5FolderFlags, int bufferSize, ISimpleLogger ioSpeedLogger) {
        this.packageFile = packageFile;
        this.h5FolderFlags = h5FolderFlags;
        this.bufferSize = bufferSize;
        this.ioSpeedLogger = ioSpeedLogger;
    }

    @Override
    public DataSetPathInfo getRootPathInfo() {
        return this.tryGetPathInfoByRelativePath(Collections.min(this.getPathInfoChildren().keySet()));
    }

    @Override
    public DataSetPathInfo tryGetPathInfoByRelativePath(String relativePath) {
        return this.getPathInfos().get(relativePath);
    }

    @Override
    public List<DataSetPathInfo> listChildrenPathInfos(DataSetPathInfo parent) {
        return this.getPathInfoChildren().get(parent.getRelativePath());
    }

    @Override
    public List<DataSetPathInfo> listMatchingPathInfos(String relativePathPattern) {
        ArrayList<DataSetPathInfo> result = new ArrayList<DataSetPathInfo>();
        Pattern pattern = Pattern.compile(relativePathPattern);
        for (DataSetPathInfo pathInfo : this.getPathInfos().values()) {
            if (!pattern.matcher(pathInfo.getRelativePath()).matches()) continue;
            result.add(pathInfo);
        }
        return result;
    }

    @Override
    public List<DataSetPathInfo> listMatchingPathInfos(String startingPath, String fileNamePattern) {
        ArrayList<DataSetPathInfo> result = new ArrayList<DataSetPathInfo>();
        Pattern pattern = Pattern.compile(fileNamePattern);
        for (DataSetPathInfo pathInfo : this.getPathInfos().values()) {
            if (!pathInfo.getRelativePath().startsWith(startingPath) || !pattern.matcher(pathInfo.getFileName()).matches()) continue;
            result.add(pathInfo);
        }
        return result;
    }

    private Map<String, List<DataSetPathInfo>> getPathInfoChildren() {
        this.getPathInfos();
        return this.pathInfoChildren;
    }

    private Map<String, DataSetPathInfo> getPathInfos() {
        if (this.pathInfos == null) {
            MonitoredIOStreamCopier copier = new MonitoredIOStreamCopier(this.bufferSize);
            copier.setLogger(this.ioSpeedLogger);
            UntarMetaData untar = null;
            try {
                this.pathInfos = new TreeMap<String, DataSetPathInfo>();
                untar = new UntarMetaData(this.packageFile, new H5FolderChecker(this.h5FolderFlags), copier, this.pathInfos);
                untar.extract(null);
                this.createPathInfoLinks();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
            finally {
                if (untar != null) {
                    try {
                        untar.close();
                    }
                    catch (IOException e) {
                        throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                    }
                }
            }
        }
        return this.pathInfos;
    }

    private void createPathInfoLinks() {
        this.pathInfoChildren = new HashMap<String, List<DataSetPathInfo>>();
        for (DataSetPathInfo pathInfo : this.pathInfos.values()) {
            String relativePath = pathInfo.getRelativePath();
            String parentRelativePath = FileUtilities.getParentRelativePath((String)relativePath);
            if (!StringUtils.isNotBlank((CharSequence)parentRelativePath)) continue;
            DataSetPathInfo parentPathInfo = this.pathInfos.get(parentRelativePath);
            pathInfo.setParent(parentPathInfo);
            List<DataSetPathInfo> children = this.pathInfoChildren.get(parentRelativePath);
            if (children == null) {
                children = new ArrayList<DataSetPathInfo>();
                this.pathInfoChildren.put(parentRelativePath, children);
            }
            children.add(pathInfo);
        }
    }

    private static final void addDirectory(String path, Map<String, DataSetPathInfo> pathInfos) {
        if (StringUtils.isNotBlank((CharSequence)path) && !pathInfos.containsKey(path)) {
            DataSetPathInfo pathInfo = new DataSetPathInfo();
            pathInfo.setDirectory(true);
            pathInfo.setFileName(FileUtilities.getFileNameFromRelativePath((String)path));
            pathInfo.setRelativePath(path);
            pathInfos.put(path, pathInfo);
            TarBasedPathInfoProvider.addDirectory(FileUtilities.getParentRelativePath((String)path), pathInfos);
        }
    }

    private static final class PathInfoOutputStream
    extends FilterOutputStream {
        private final TarArchiveEntry entry;
        private final Map<String, DataSetPathInfo> pathInfos;
        private final Checksum checksum;
        private long fileSize;
        private OutputStream fileOutputStream;
        private File tmpFile;

        public PathInfoOutputStream(TarArchiveEntry entry, H5FolderChecker folderChecker, Map<String, DataSetPathInfo> pathInfos) {
            super((OutputStream)new NullOutputStream());
            this.entry = entry;
            this.pathInfos = pathInfos;
            this.checksum = new CRC32();
            String name = entry.getName();
            if (folderChecker.handleHdf5AsFolder(name)) {
                try {
                    this.tmpFile = Files.createTempFile("openbis", "untarh5", new FileAttribute[0]).toFile();
                    System.out.println("temp file: " + this.tmpFile.getAbsolutePath());
                    this.tmpFile.deleteOnExit();
                    this.fileOutputStream = new FileOutputStream(this.tmpFile);
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            } else {
                this.fileOutputStream = new NullOutputStream();
            }
        }

        protected void finalize() throws Throwable {
            this.fileOutputStream.close();
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.fileOutputStream.write(b);
            this.checksum.update(b);
            ++this.fileSize;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.fileOutputStream.write(b, off, len);
            this.checksum.update(b, off, len);
            this.fileSize += (long)len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            this.fileOutputStream.close();
            String name = this.entry.getName();
            if (this.tmpFile == null) {
                this.addAsPathInfo(name);
            } else {
                try (IHDF5ContainerReader reader = new HDF5Container(this.tmpFile).createSimpleReader();){
                    if (HierarchicalContentUtils.isFileAbstractionOk((IHDF5ContainerReader)reader, (String)"/")) {
                        List entries = reader.getGroupMembers("/");
                        for (ArchiveEntry archiveEntry : entries) {
                            this.handleEntry(name, reader, archiveEntry);
                        }
                    } else {
                        this.addAsPathInfo(name);
                    }
                }
            }
        }

        private void addAsPathInfo(String name) {
            DataSetPathInfo pathInfo = new DataSetPathInfo();
            pathInfo.setChecksumCRC32((int)this.checksum.getValue());
            pathInfo.setDirectory(false);
            pathInfo.setFileName(FileUtilities.getFileNameFromRelativePath((String)name));
            pathInfo.setLastModified(this.entry.getLastModifiedDate());
            pathInfo.setRelativePath(name);
            pathInfo.setSizeInBytes(this.fileSize);
            this.pathInfos.put(name, pathInfo);
            TarBasedPathInfoProvider.addDirectory(FileUtilities.getParentRelativePath((String)name), this.pathInfos);
        }

        private void handleEntry(String name, IHDF5ContainerReader reader, ArchiveEntry archiveEntry) {
            String path = name + archiveEntry.getPath();
            DataSetPathInfo pathInfo = new DataSetPathInfo();
            pathInfo.setChecksumCRC32(archiveEntry.getCrc32());
            pathInfo.setDirectory(archiveEntry.isDirectory());
            pathInfo.setLastModified(new Date(archiveEntry.getLastModified()));
            pathInfo.setRelativePath(path);
            pathInfo.setFileName(archiveEntry.getName());
            pathInfo.setSizeInBytes(archiveEntry.getSize());
            this.pathInfos.put(path, pathInfo);
            TarBasedPathInfoProvider.addDirectory(FileUtilities.getParentRelativePath((String)path), this.pathInfos);
            if (archiveEntry.isDirectory()) {
                List groupMembers = reader.getGroupMembers(archiveEntry.getPath());
                for (ArchiveEntry childEntry : groupMembers) {
                    this.handleEntry(name, reader, childEntry);
                }
            }
        }
    }

    private static final class UntarMetaData
    extends Untar {
        private Map<String, DataSetPathInfo> pathInfos;
        private H5FolderChecker folderChecker;

        public UntarMetaData(File tarFile, H5FolderChecker folderChecker, MonitoredIOStreamCopier copier, Map<String, DataSetPathInfo> pathInfos) throws FileNotFoundException {
            super(tarFile, copier);
            this.folderChecker = folderChecker;
            this.pathInfos = pathInfos;
        }

        protected OutputStream createOutputStream(File entryFile, TarArchiveEntry entry) throws IOException {
            return new PathInfoOutputStream(entry, this.folderChecker, this.pathInfos);
        }

        protected void createDirectory(File directory) {
            TarBasedPathInfoProvider.addDirectory(directory.getPath(), this.pathInfos);
        }

        protected void createParentDirectories(File file) {
        }

        protected void createSymbolicLink(File file, TarArchiveEntry entry) {
        }

        protected void createHardLink(File file, TarArchiveEntry entry) {
        }

        protected void setFileMetadata(File entryFile, TarArchiveEntry entry) {
        }
    }
}

