/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderFlags;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.TarBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.TarDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.TarBasedPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.PathInfoProviderBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class TarPackageManager
extends AbstractPackageManager {
    private static final String MAXIMUM_QUEUE_SIZE_IN_BYTES_KEY = "maximum-queue-size-in-bytes";
    private static final String BUFFER_SIZE_KEY = "buffer-size";
    private static final int DEFAULT_BUFFER_SIZE = 0xA00000;
    private final File tempFolder;
    private final int bufferSize;
    protected final ISimpleLogger logger;
    private Long maxQueueSize;

    public TarPackageManager(Properties properties, ISimpleLogger ioSpeedLogger) {
        this.tempFolder = PropertyUtils.getDirectory((Properties)properties, (String)"temp-folder", null);
        this.bufferSize = PropertyUtils.getInt((Properties)properties, (String)BUFFER_SIZE_KEY, (int)0xA00000);
        long maxSize = PropertyUtils.getLong((Properties)properties, (String)MAXIMUM_QUEUE_SIZE_IN_BYTES_KEY, (long)(5 * this.bufferSize));
        this.maxQueueSize = maxSize == 0L ? null : Long.valueOf(maxSize);
        this.logger = ioSpeedLogger;
    }

    @Override
    public String getName(String dataSetCode) {
        return dataSetCode + ".tar";
    }

    @Override
    protected AbstractDataSetPackager createPackager(File packageFile, DataSetExistenceChecker existenceChecker) {
        return new TarDataSetPackager(packageFile, this.getContentProvider(), existenceChecker, this.bufferSize, this.maxQueueSize);
    }

    @Override
    public List<VerificationError> verify(File packageFile) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status extract(File packageFile, File toDirectory) {
        Untar untar = null;
        try {
            untar = new Untar(packageFile);
            untar.extract(toDirectory);
            File metadataFile = new File(toDirectory, "meta-data.tsv");
            if (metadataFile.exists() && metadataFile.isFile()) {
                FileUtilities.delete((File)metadataFile);
            }
            Status status = Status.OK;
            return status;
        }
        catch (Exception ex) {
            Status status = Status.createError((String)ex.toString());
            return status;
        }
        finally {
            if (untar != null) {
                try {
                    untar.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        }
    }

    @Override
    public IHierarchicalContent asHierarchialContent(File packageFile, List<DatasetDescription> dataSets, boolean onlyMetaData) {
        List<H5FolderFlags> h5FolderFlags = this.extractH5FolderFlags(dataSets);
        if (onlyMetaData) {
            TarBasedPathInfoProvider pathInfoProvider = new TarBasedPathInfoProvider(packageFile, h5FolderFlags, this.bufferSize, this.logger);
            return new PathInfoProviderBasedHierarchicalContent(pathInfoProvider, null, new IDelegatedAction(){

                public void execute() {
                }
            });
        }
        return new TarBasedHierarchicalContent(packageFile, h5FolderFlags, this.tempFolder, this.bufferSize, this.logger);
    }
}

