/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.List;

public abstract class AbstractDataSetFileOperationsManager {
    @Private
    public static final String DESTINATION_KEY = "destination";
    @Private
    public static final String TIMEOUT_KEY = "timeout";
    @Private
    public static final String RSYNC_PASSWORD_FILE_KEY = "rsync-password-file";
    @Private
    protected static final String CHECK_EXISTENCE_FAILED = "couldn't check existence";
    @Private
    public static final String DESTINATION_DOES_NOT_EXIST = "destination doesn't exist";
    @Private
    public static final String RSYNC_EXEC = "rsync";
    @Private
    public static final String SSH_EXEC = "ssh";
    @Private
    public static final String GFIND_EXEC = "find";
    @Private
    public static final long DEFAULT_TIMEOUT_SECONDS = 15L;
    @Private
    public static final String FOLDER_OF_AS_DELETED_MARKED_DATA_SETS = "DELETED";
    protected transient IEncapsulatedOpenBISService service;
    protected transient IDataSetDirectoryProvider directoryProvider;

    protected IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    protected IDataSetDirectoryProvider getDirectoryProvider() {
        if (this.directoryProvider == null) {
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        return this.directoryProvider;
    }

    protected AbstractExternalData getDataSetWithAllMetaData(DatasetDescription datasetDescription) {
        List containerDataSets;
        String sampleIdentifier;
        AbstractExternalData dataSet = this.getService().tryGetDataSet(datasetDescription.getDataSetCode());
        String experimentIdentifier = datasetDescription.getExperimentIdentifier();
        if (experimentIdentifier != null) {
            dataSet.setExperiment(this.getService().tryGetExperiment(ExperimentIdentifierFactory.parse((String)experimentIdentifier)));
        }
        if ((sampleIdentifier = datasetDescription.getSampleIdentifier()) != null) {
            dataSet.setSample(this.getService().tryGetSampleWithExperiment(SampleIdentifierFactory.parse((String)sampleIdentifier)));
        }
        if ((containerDataSets = dataSet.getContainerDataSets()) != null) {
            for (ContainerDataSet containerDataSet : containerDataSets) {
                if (containerDataSet.getProperties() == null) {
                    containerDataSet.setDataSetProperties(this.getService().tryGetDataSet(containerDataSet.getCode()).getProperties());
                }
                String containerExperimentIdentifier = containerDataSet.getExperiment().getIdentifier();
                containerDataSet.setExperiment(this.getService().tryGetExperiment(ExperimentIdentifierFactory.parse((String)containerExperimentIdentifier)));
                Sample sample = containerDataSet.getSample();
                if (sample == null) continue;
                String containerSampleIdentifier = sample.getIdentifier();
                containerDataSet.setSample(this.getService().tryGetSampleWithExperiment(SampleIdentifierFactory.parse((String)containerSampleIdentifier)));
            }
        }
        return dataSet;
    }
}

