/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.IMailClientProvider;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.FileDeleter;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

class MultiDataSetArchiveCleaner
implements IMultiDataSetArchiveCleaner {
    static final String FILE_PATH_PREFIXES_FOR_ASYNC_DELETION_KEY = "file-path-prefixes-for-async-deletion";
    static final String DELETION_REQUESTS_DIR_KEY = "deletion-requests-dir";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MultiDataSetArchiveCleaner.class);
    private static Map<File, FileDeleter> globalDeleters = new HashMap<File, FileDeleter>();
    private final List<String> filePathPrefixesForAsyncDeletion;
    private File deletionRequestsDir;
    private final Map<File, FileDeleter> deleters;

    MultiDataSetArchiveCleaner(Properties properties) {
        this(properties, SystemTimeProvider.SYSTEM_TIME_PROVIDER, globalDeleters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiDataSetArchiveCleaner(Properties properties, ITimeAndWaitingProvider timeProvider, Map<File, FileDeleter> deleters) {
        this.deleters = deleters;
        this.filePathPrefixesForAsyncDeletion = this.getPathPrefixesForAsyncDeletion(properties);
        if (this.filePathPrefixesForAsyncDeletion.isEmpty()) {
            return;
        }
        this.deletionRequestsDir = new File(PropertyUtils.getMandatoryProperty((Properties)properties, (String)DELETION_REQUESTS_DIR_KEY));
        if (this.deletionRequestsDir.isFile()) {
            throw new ConfigurationFailureException("Property 'deletion-requests-dir' denotes an existing file instead of a directory: " + this.deletionRequestsDir);
        }
        if (!this.deletionRequestsDir.exists() && !this.deletionRequestsDir.mkdirs()) {
            throw new ConfigurationFailureException("Couldn't create directory: " + this.deletionRequestsDir);
        }
        Map<File, FileDeleter> map = deleters;
        synchronized (map) {
            FileDeleter deleter = deleters.get(this.deletionRequestsDir);
            if (deleter == null) {
                deleter = new FileDeleter(this.deletionRequestsDir, timeProvider, new IMailClientProvider(){

                    public IMailClient getMailClient() {
                        return ServiceProvider.getDataStoreService().createEMailClient();
                    }
                }, properties);
                deleters.put(this.deletionRequestsDir, deleter);
            }
            deleter.start();
        }
    }

    private List<String> getPathPrefixesForAsyncDeletion(Properties properties) {
        List relativeFilePathPrefixesForAsyncDeletion = PropertyUtils.getList((Properties)properties, (String)FILE_PATH_PREFIXES_FOR_ASYNC_DELETION_KEY);
        ArrayList<String> result = new ArrayList<String>();
        for (String path : relativeFilePathPrefixesForAsyncDeletion) {
            result.add(new File(path).getAbsolutePath());
        }
        return result;
    }

    @Override
    public void delete(File file) {
        if (this.isFileForAsyncDeletion(file)) {
            FileDeleter deleter = this.deleters.get(this.deletionRequestsDir);
            deleter.requestDeletion(file);
        } else {
            this.deleteSync(file);
        }
    }

    private void deleteSync(File file) {
        if (file.delete()) {
            operationLog.info((Object)("File immediately deleted: " + file));
        } else {
            operationLog.warn((Object)("Failed to delete file immediately: " + file));
        }
    }

    private boolean isFileForAsyncDeletion(File file) {
        String path = file.getAbsolutePath();
        for (String prefix : this.filePathPrefixesForAsyncDeletion) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

