/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractArchiverProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiveCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.SshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchivingFinalizer;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchivingUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverContainerDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSourceUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IUnarchivingPreparation;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.translator.SimpleDataSetHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class MultiDataSetArchiver
extends AbstractArchiverProcessingPlugin {
    static final String ARCHIVING_FINALIZER = "Archiving Finalizer";
    private static final long serialVersionUID = 1L;
    private transient IMultiDataSetFileOperationsManager fileOperations;
    private final FileOperationsManagerFactory fileOperationsFactory;
    public static final String MINIMUM_FREE_SPACE_AT_FINAL_DESTINATION_IN_BYTES = "minimum-free-space-at-final-destination-in-bytes";
    public static final String MINIMUM_FREE_SPACE_AT_FINAL_DESTINATION_IN_PERCENTAGE = "minimum-free-space-at-final-destination-in-percentage";
    public static final String MINIMUM_CONTAINER_SIZE_IN_BYTES = "minimum-container-size-in-bytes";
    public static final Long DEFAULT_MINIMUM_CONTAINER_SIZE_IN_BYTES = 0x280000000L;
    public static final String MAXIMUM_CONTAINER_SIZE_IN_BYTES = "maximum-container-size-in-bytes";
    public static final String MAXIMUM_UNARCHIVING_CAPACITY_IN_MEGABYTES = "maximum-unarchiving-capacity-in-megabytes";
    public static final Long DEFAULT_MAXIMUM_CONTAINER_SIZE_IN_BYTES = 0x1400000000L;
    public static final long DEFAULT_FINALIZER_POLLING_TIME = 60000L;
    public static final long DEFAULT_FINALIZER_MAX_WAITING_TIME = 86400000L;
    public static final Long DEFAULT_UNARCHIVING_CAPACITY_IN_MEGABYTES = 0xFA00000000L;
    public static final String DELAY_UNARCHIVING = "delay-unarchiving";
    public static final String CLEANER_PROPS = "cleaner";
    private transient IMultiDataSetArchiverReadonlyQueryDAO readonlyQuery;
    private transient IDataStoreServiceInternal dataStoreService;
    private transient IMultiDataSetArchiveCleaner cleaner;
    private final long absoluteMinimumFreeSpaceAtDestination;
    private final int relativeMinimumFreeSpaceAtDestination;
    private final String finalDestination;
    private final long minimumContainerSize;
    private final long maximumContainerSize;
    private final long maximumUnarchivingCapacityInMB;
    private final boolean delayUnarchiving;
    private final long finalizerPollingTime;
    private final long finalizerMaxWaitingTime;
    private final Properties cleanerProperties;
    private ITimeAndWaitingProvider timeProvider;

    public MultiDataSetArchiver(Properties properties, File storeRoot) {
        this(properties, storeRoot, SystemTimeProvider.SYSTEM_TIME_PROVIDER, null);
    }

    MultiDataSetArchiver(Properties properties, File storeRoot, ITimeAndWaitingProvider timeProvider, IFreeSpaceProvider freeSpaceProviderOrNull) {
        super(properties, storeRoot, null, null);
        this.timeProvider = timeProvider;
        this.delayUnarchiving = PropertyUtils.getBoolean((Properties)properties, (String)DELAY_UNARCHIVING, (boolean)false);
        this.absoluteMinimumFreeSpaceAtDestination = PropertyUtils.getLong((Properties)properties, (String)MINIMUM_FREE_SPACE_AT_FINAL_DESTINATION_IN_BYTES, (long)-1L);
        this.relativeMinimumFreeSpaceAtDestination = PropertyUtils.getInt((Properties)properties, (String)MINIMUM_FREE_SPACE_AT_FINAL_DESTINATION_IN_PERCENTAGE, (int)-1);
        this.finalDestination = properties.getProperty("final-destination");
        this.minimumContainerSize = PropertyUtils.getLong((Properties)properties, (String)MINIMUM_CONTAINER_SIZE_IN_BYTES, (long)DEFAULT_MINIMUM_CONTAINER_SIZE_IN_BYTES);
        this.maximumContainerSize = PropertyUtils.getLong((Properties)properties, (String)MAXIMUM_CONTAINER_SIZE_IN_BYTES, (long)DEFAULT_MAXIMUM_CONTAINER_SIZE_IN_BYTES);
        this.maximumUnarchivingCapacityInMB = PropertyUtils.getLong((Properties)properties, (String)MAXIMUM_UNARCHIVING_CAPACITY_IN_MEGABYTES, (long)DEFAULT_UNARCHIVING_CAPACITY_IN_MEGABYTES);
        this.fileOperationsFactory = new FileOperationsManagerFactory(properties, timeProvider, freeSpaceProviderOrNull);
        this.finalizerPollingTime = DateTimeUtils.getDurationInMillis((Properties)properties, (String)"finalizer-polling-time", (long)60000L);
        this.finalizerMaxWaitingTime = DateTimeUtils.getDurationInMillis((Properties)properties, (String)"finalizer-max-waiting-time", (long)86400000L);
        this.cleanerProperties = PropertyParametersUtil.extractSingleSectionProperties((Properties)properties, (String)CLEANER_PROPS, (boolean)false).getProperties();
        this.getCleaner();
    }

    @Override
    public boolean isArchivingPossible() {
        boolean possible = super.isArchivingPossible();
        if (possible && (this.absoluteMinimumFreeSpaceAtDestination > 0L || this.relativeMinimumFreeSpaceAtDestination > 0)) {
            try {
                FileStore fileStore = Files.getFileStore(new File(this.finalDestination).toPath());
                long usableSpace = fileStore.getUsableSpace();
                if (this.absoluteMinimumFreeSpaceAtDestination > 0L) {
                    boolean bl = possible = usableSpace >= this.absoluteMinimumFreeSpaceAtDestination;
                    if (!possible) {
                        operationLog.warn((Object)("Archiving not triggered because the usable free space " + FileUtils.byteCountToDisplaySize((long)usableSpace) + " is less then the specified minimum free space " + FileUtils.byteCountToDisplaySize((long)this.absoluteMinimumFreeSpaceAtDestination)));
                    }
                }
                if (possible && this.relativeMinimumFreeSpaceAtDestination > 0) {
                    long totalSpace = fileStore.getTotalSpace();
                    long percentage = usableSpace * 100L / totalSpace;
                    boolean bl = possible = percentage >= (long)this.relativeMinimumFreeSpaceAtDestination;
                    if (!possible) {
                        operationLog.warn((Object)("Archiving not triggered because the usable free space is only " + percentage + "% of the total space " + FileUtils.byteCountToDisplaySize((long)totalSpace) + " but the specified minimum is " + this.relativeMinimumFreeSpaceAtDestination + "%."));
                    }
                }
            }
            catch (IOException e) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
            }
        }
        return possible;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doArchive(List<DatasetDescription> paramDataSets, ArchiverTaskContext context, boolean removeFromDataStore) {
        LinkedList<DatasetDescription> dataSets = new LinkedList<DatasetDescription>(paramDataSets);
        MultiDataSetProcessingStatuses result = new MultiDataSetProcessingStatuses();
        this.filterBasedOnArchiveStatus(dataSets, result, FilterOption.FILTER_ARCHIVED, Status.OK, AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        if (dataSets.isEmpty()) {
            return result;
        }
        IMultiDataSetArchiverDBTransaction transaction = this.getTransaction();
        try {
            this.verifyDataSetsSize(dataSets);
            MultiDataSetProcessingStatuses archiveResult = this.archiveDataSets(dataSets, context, removeFromDataStore, transaction);
            result.addResults(archiveResult);
            transaction.commit();
            transaction.close();
        }
        catch (Exception e) {
            operationLog.warn((Object)("Archiving of " + dataSets.size() + " data sets failed"), (Throwable)e);
            try {
                transaction.rollback();
                transaction.close();
            }
            catch (Exception ex) {
                operationLog.warn((Object)"Rollback of multi dataset db transaction failed", (Throwable)ex);
            }
            result.addResult(dataSets, Status.createError((String)e.getMessage()), AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        }
        operationLog.info((Object)("archiving done. result: " + result.getDataSetsWaitingForReplication()));
        return result;
    }

    private void filterBasedOnArchiveStatus(LinkedList<? extends IDatasetLocation> dataSets, AbstractArchiverProcessingPlugin.DatasetProcessingStatuses result, FilterOption filterOption, Status status, AbstractArchiverProcessingPlugin.Operation operation) {
        Iterator iterator = dataSets.iterator();
        while (iterator.hasNext()) {
            boolean isFiltered;
            IDatasetLocation dataSet = (IDatasetLocation)iterator.next();
            boolean isPresentInArchive = this.isDataSetPresentInArchive(dataSet.getDataSetCode());
            switch (filterOption) {
                case FILTER_ARCHIVED: {
                    isFiltered = isPresentInArchive;
                    break;
                }
                case FILTER_UNARCHIVED: {
                    isFiltered = false == isPresentInArchive;
                    break;
                }
                default: {
                    throw new IllegalStateException("All cases should be covered");
                }
            }
            if (!isFiltered) continue;
            result.addResult(dataSet.getDataSetCode(), status, operation);
            iterator.remove();
        }
    }

    private void verifyDataSetsSize(List<DatasetDescription> dataSets) {
        long datasetSize = SegmentedStoreUtils.calculateTotalSize(dataSets);
        if (dataSets.size() == 1) {
            if (datasetSize < this.minimumContainerSize) {
                throw new IllegalArgumentException("Dataset " + dataSets.get(0).getDataSetCode() + " is too small (" + FileUtilities.byteCountToDisplaySize((long)datasetSize) + ") to be archived with multi dataset archiver because minimum size is " + FileUtilities.byteCountToDisplaySize((long)this.minimumContainerSize) + ".");
            }
        } else {
            if (datasetSize < this.minimumContainerSize) {
                throw new IllegalArgumentException("Set of data sets specified for archiving is too small (" + FileUtilities.byteCountToDisplaySize((long)datasetSize) + ") to be archived with multi dataset archiver because minimum size is " + FileUtilities.byteCountToDisplaySize((long)this.minimumContainerSize) + ".");
            }
            if (datasetSize > this.maximumContainerSize) {
                throw new IllegalArgumentException("Set of data sets specified for archiving is too big (" + FileUtilities.byteCountToDisplaySize((long)datasetSize) + ") to be archived with multi dataset archiver because maximum size is " + FileUtilities.byteCountToDisplaySize((long)this.maximumContainerSize) + ".");
            }
        }
    }

    private MultiDataSetProcessingStatuses archiveDataSets(List<DatasetDescription> dataSets, ArchiverTaskContext context, boolean removeFromDataStore, IMultiDataSetArchiverDBTransaction transaction) throws Exception {
        MultiDataSetProcessingStatuses statuses = new MultiDataSetProcessingStatuses();
        String containerPath = this.createContainerPath(dataSets, context);
        long containerId = this.establishContainerDataSetMapping(dataSets, containerPath, transaction);
        IHierarchicalContent archivedContent = null;
        try {
            Status status = this.getFileOperations().createContainer(containerPath, dataSets);
            if (status.isError()) {
                throw new Exception("Couldn't create archive file " + containerPath + ". Reason: " + status.tryGetErrorMessage());
            }
            archivedContent = this.getFileOperations().getContainerAsHierarchicalContent(containerPath, dataSets);
            this.checkArchivedDataSets(archivedContent, dataSets, context, statuses);
            this.scheduleFinalizer(containerPath, containerId, dataSets, context, removeFromDataStore, statuses);
        }
        catch (Exception ex) {
            this.getFileOperations().deleteContainerFromFinalDestination(this.getCleaner(), containerPath);
            throw ex;
        }
        finally {
            this.getFileOperations().deleteContainerFromStage(this.getCleaner(), containerPath);
            if (archivedContent != null) {
                archivedContent.close();
            }
        }
        return statuses;
    }

    private String createContainerPath(List<DatasetDescription> dataSets, ArchiverTaskContext context) {
        String containerPath = this.getFileOperations().generateContainerPath(dataSets);
        String subDirectory = this.tryGetSubDirectory(context);
        if (subDirectory != null) {
            containerPath = subDirectory + "/" + containerPath;
        }
        return containerPath;
    }

    private String tryGetSubDirectory(ArchiverTaskContext context) {
        Map<String, String> options = context.getOptions();
        return options != null ? options.get("sub-directory") : null;
    }

    private long establishContainerDataSetMapping(List<DatasetDescription> dataSets, String containerPath, IMultiDataSetArchiverDBTransaction transaction) {
        MultiDataSetArchiverContainerDTO container = transaction.createContainer(containerPath);
        for (DatasetDescription dataSet : dataSets) {
            transaction.insertDataset(dataSet, container);
        }
        return container.getId();
    }

    private void scheduleFinalizer(String containerPath, long containerId, List<DatasetDescription> dataSets, ArchiverTaskContext archiverContext, boolean removeFromDataStore, MultiDataSetProcessingStatuses statuses) {
        if (!this.needsToWaitForReplication()) {
            return;
        }
        statuses.setDataSetsWaitingForReplication(dataSets);
        MultiDataSetArchivingFinalizer task = new MultiDataSetArchivingFinalizer(this.cleanerProperties, this.pauseFile, this.pauseFilePollingTime, this.getTimeProvider());
        String userId = archiverContext.getUserId();
        String userEmail = archiverContext.getUserEmail();
        String userSessionToken = archiverContext.getUserSessionToken();
        LinkedHashMap<String, String> parameterBindings = new LinkedHashMap<String, String>();
        IMultiDataSetFileOperationsManager operations = this.getFileOperations();
        String groupKey = this.tryGetSubDirectory(archiverContext);
        if (groupKey != null) {
            parameterBindings.put("sub-directory", groupKey);
        }
        parameterBindings.put("container-id", Long.toString(containerId));
        parameterBindings.put("original-file-path", operations.getOriginalArchiveFilePath(containerPath));
        parameterBindings.put("replicated-file-path", operations.getReplicatedArchiveFilePath(containerPath));
        parameterBindings.put("finalizer-polling-time", Long.toString(this.finalizerPollingTime));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        parameterBindings.put("start-time", dateFormat.format(this.getTimeProvider().getTimeInMilliseconds()));
        parameterBindings.put("finalizer-max-waiting-time", Long.toString(this.finalizerMaxWaitingTime));
        DataSetArchivingStatus status = removeFromDataStore ? DataSetArchivingStatus.ARCHIVED : DataSetArchivingStatus.AVAILABLE;
        parameterBindings.put("status", status.toString());
        this.getDataStoreService().scheduleTask(ARCHIVING_FINALIZER, task, parameterBindings, dataSets, userId, userEmail, userSessionToken);
    }

    private boolean needsToWaitForReplication() {
        return this.getFileOperations().isReplicatedArchiveDefined();
    }

    private void checkArchivedDataSets(IHierarchicalContent archivedContent, List<DatasetDescription> dataSets, ArchiverTaskContext context, AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses) {
        Map<String, Status> statusMap = MultiDataSetArchivingUtils.sanityCheck(archivedContent, dataSets, context, (ISimpleLogger)new Log4jSimpleLogger(operationLog));
        if (!this.needsToWaitForReplication()) {
            for (String dataSetCode : statusMap.keySet()) {
                statuses.addResult(dataSetCode, statusMap.get(dataSetCode), AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
            }
        }
    }

    @Override
    protected List<DatasetDescription> getArchivedDataSets(List<DatasetDescription> datasets, AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses) {
        List<DatasetDescription> dataSetsWaitingForReplication;
        List<DatasetDescription> archivedDataSets = super.getArchivedDataSets(datasets, statuses);
        if (statuses instanceof MultiDataSetProcessingStatuses && (dataSetsWaitingForReplication = ((MultiDataSetProcessingStatuses)statuses).getDataSetsWaitingForReplication()) != null) {
            archivedDataSets.removeAll(dataSetsWaitingForReplication);
        }
        return archivedDataSets;
    }

    @Override
    public List<String> getDataSetCodesForUnarchiving(List<String> dataSetCodes) {
        Set<Long> containerIds = this.assertUnarchivingCapacityNotExceeded(dataSetCodes);
        return this.getCodesOfAllDataSetsInContainer(containerIds);
    }

    @Override
    protected IUnarchivingPreparation getUnarchivingPreparation() {
        Share scratchShare = this.findScratchShare();
        IDataSetDirectoryProvider directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        return new MultiDataSetUnarchivingPreparations(scratchShare, this.getShareIdManager(), this.getService(), directoryProvider);
    }

    private Share findScratchShare() {
        IFreeSpaceProvider freeSpaceProvider;
        Set<String> incomingShares;
        String dataStoreCode = ServiceProvider.getConfigProvider().getDataStoreCode();
        List<Share> shares = SegmentedStoreUtils.getSharesWithDataSets(this.storeRoot, dataStoreCode, SegmentedStoreUtils.FilterOptions.ARCHIVING_SCRATCH, incomingShares = IncomingShareIdProvider.getIdsOfIncomingShares(), freeSpaceProvider = this.createFreeSpaceProvider(), this.getService(), (ISimpleLogger)new Log4jSimpleLogger(operationLog));
        if (shares.size() != 1) {
            throw new ConfigurationFailureException("There should be exactly one unarchiving scratch share configured!");
        }
        Share scratchShare = shares.get(0);
        return scratchShare;
    }

    @Override
    protected boolean delayUnarchiving(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        if (!this.delayUnarchiving || context.isForceUnarchiving()) {
            return false;
        }
        IMultiDataSetArchiverDBTransaction transaction = this.getTransaction();
        try {
            List<String> dataSetCodes = this.translateToDataSetCodes(datasets);
            transaction.requestUnarchiving(dataSetCodes);
            transaction.commit();
            transaction.close();
        }
        catch (Exception e) {
            operationLog.warn((Object)("Requesting unarchiving of " + datasets.size() + " data sets failed"), (Throwable)e);
            try {
                transaction.rollback();
                transaction.close();
            }
            catch (Exception ex) {
                operationLog.warn((Object)"Rollback of multi dataset db transaction failed", (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doUnarchive(List<DatasetDescription> dataSets, ArchiverTaskContext context) {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses result = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        List<String> dataSetCodes = this.translateToDataSetCodes(dataSets);
        Set<Long> containerIds = this.assertUnarchivingCapacityNotExceeded(dataSetCodes);
        this.assertNoAvailableDatasets(dataSetCodes);
        context.getUnarchivingPreparation().prepareForUnarchiving(dataSets);
        IMultiDataSetFileOperationsManager operations = this.getFileOperations();
        for (Long containerId : containerIds) {
            MultiDataSetArchiverContainerDTO container = this.getReadonlyQuery().getContainerForId(containerId);
            Status status = operations.restoreDataSetsFromContainerInFinalDestination(container.getPath(), dataSets);
            if (!status.isError()) continue;
            result.addResult(dataSets, status, AbstractArchiverProcessingPlugin.Operation.UNARCHIVE);
            return result;
        }
        IHierarchicalContentProvider contentProvider = context.getHierarchicalContentProvider();
        for (String dataSetCode : dataSetCodes) {
            IHierarchicalContent content = contentProvider.asContentWithoutModifyingAccessTimestamp(dataSetCode);
            IHierarchicalContentNode rootNode = content.getRootNode();
            this.assertFilesExists(dataSetCode, rootNode);
        }
        for (String dataSetCode : dataSetCodes) {
            this.getService().notifyDatasetAccess(dataSetCode);
        }
        result.addResult(dataSets, Status.OK, AbstractArchiverProcessingPlugin.Operation.UNARCHIVE);
        return result;
    }

    private void assertFilesExists(String dataSetCode, IHierarchicalContentNode node) {
        File file;
        try {
            file = node.getFile();
        }
        catch (UnsupportedOperationException ex) {
            throw this.createException(dataSetCode, node, ex);
        }
        if (!file.exists()) {
            throw this.createException(dataSetCode, node, null);
        }
        if (node.isDirectory() && !FileUtilities.isHDF5ContainerFile((File)file)) {
            for (IHierarchicalContentNode child : node.getChildNodes()) {
                this.assertFilesExists(dataSetCode, child);
            }
        }
    }

    private EnvironmentFailureException createException(String dataSetCode, IHierarchicalContentNode node, Exception exOrNull) {
        String message = "Data set " + dataSetCode + ": File '" + node.getRelativePath() + "' does not exist.";
        if (exOrNull != null) {
            return new EnvironmentFailureException(message + " (reason: " + exOrNull.getMessage() + ")", (Throwable)exOrNull);
        }
        return new EnvironmentFailureException(message);
    }

    private void assertNoAvailableDatasets(List<String> dataSetCodes) {
        List<PhysicalDataSet> dataSets = this.translateToPhysicalDataSets(dataSetCodes);
        for (PhysicalDataSet physicalDataSet : dataSets) {
            if (!physicalDataSet.isAvailable()) continue;
            throw new UserFailureException("Dataset '" + physicalDataSet.getCode() + "'specified for unarchiving is available");
        }
    }

    private List<String> getCodesOfAllDataSetsInContainer(Set<Long> containerIds) {
        LinkedList<String> enhancedDataSetCodes = new LinkedList<String>();
        for (Long containerId : containerIds) {
            List<MultiDataSetArchiverDataSetDTO> datasetsInContainer = this.getReadonlyQuery().listDataSetsForContainerId(containerId);
            for (MultiDataSetArchiverDataSetDTO dataSet : datasetsInContainer) {
                enhancedDataSetCodes.add(dataSet.getCode());
            }
        }
        return enhancedDataSetCodes;
    }

    private List<PhysicalDataSet> translateToPhysicalDataSets(List<String> dataSetCodes) {
        LinkedList<PhysicalDataSet> result = new LinkedList<PhysicalDataSet>();
        for (AbstractExternalData dataSet : this.getService().listDataSetsByCode(dataSetCodes)) {
            if (dataSet.tryGetAsDataSet() != null) {
                result.add(dataSet.tryGetAsDataSet());
                continue;
            }
            throw new IllegalStateException("All data sets in container are expected to be physical datasets, but data set '" + dataSet.getCode() + "' is not ");
        }
        return result;
    }

    private List<String> translateToDataSetCodes(List<? extends IDatasetLocation> dataSets) {
        LinkedList<String> result = new LinkedList<String>();
        for (IDatasetLocation iDatasetLocation : dataSets) {
            result.add(iDatasetLocation.getDataSetCode());
        }
        return result;
    }

    private Set<Long> assertUnarchivingCapacityNotExceeded(List<String> dataSetCodes) {
        long totalSizeOfUnarchivingRequested;
        Set<Long> containers = this.getContainers(dataSetCodes);
        long totalSumInBytes = totalSizeOfUnarchivingRequested = this.getReadonlyQuery().getTotalNoOfBytesInContainersWithUnarchivingRequested();
        for (Long containerId : containers) {
            List<MultiDataSetArchiverDataSetDTO> dataSets = this.getReadonlyQuery().listDataSetsForContainerId(containerId);
            for (MultiDataSetArchiverDataSetDTO dataSet : dataSets) {
                totalSumInBytes += dataSet.getSizeInBytes();
            }
        }
        if (totalSumInBytes > this.maximumUnarchivingCapacityInMB * 0x100000L) {
            String message = String.format("Total size of selected data sets (%.2f MB) and those already scheduled for unarchiving (%.2f MB) exceeds capacity. Please narrow down your selection or try again later.", (double)(totalSumInBytes - totalSizeOfUnarchivingRequested) / 1048576.0, (double)totalSizeOfUnarchivingRequested / 1048576.0);
            throw new UserFailureException(message);
        }
        return containers;
    }

    private Set<Long> getContainers(List<String> dataSetCodes) {
        LinkedHashSet<Long> containers = new LinkedHashSet<Long>();
        for (String code : dataSetCodes) {
            MultiDataSetArchiverDataSetDTO dataSet = this.getReadonlyQuery().getDataSetForCode(code);
            if (dataSet == null) {
                throw new UserFailureException("Dataset " + code + " was selected for unarchiving, but is not present in the archive");
            }
            containers.add(dataSet.getContainerId());
        }
        return containers;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> datasets) {
        LinkedList<? extends IDatasetLocation> localDataSets = new LinkedList<IDatasetLocation>(datasets);
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses results = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        this.filterBasedOnArchiveStatus(localDataSets, results, FilterOption.FILTER_UNARCHIVED, Status.OK, AbstractArchiverProcessingPlugin.Operation.DELETE_FROM_ARCHIVE);
        if (localDataSets.size() > 0) {
            throw new NotImplementedException("Deleting from archive is not yet implemented for multi dataset archiver");
        }
        return results;
    }

    @Override
    protected BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription dataset, ArchiverTaskContext context) {
        return this.isDataSetPresentInArchive(dataset);
    }

    @Override
    protected BooleanStatus isDataSetPresentInArchive(DatasetDescription dataSet) {
        return BooleanStatus.createFromBoolean((boolean)this.isDataSetPresentInArchive(dataSet.getDataSetCode()));
    }

    protected boolean isDataSetPresentInArchive(String dataSetCode) {
        MultiDataSetArchiverDataSetDTO dataSetInArchiveDB = this.getReadonlyQuery().getDataSetForCode(dataSetCode);
        return dataSetInArchiveDB != null;
    }

    @Private
    IMultiDataSetFileOperationsManager getFileOperations() {
        if (this.fileOperations == null) {
            this.fileOperations = this.fileOperationsFactory.create();
        }
        return this.fileOperations;
    }

    @Private
    IMultiDataSetArchiverDBTransaction getTransaction() {
        return new MultiDataSetArchiverDBTransaction();
    }

    IMultiDataSetArchiverReadonlyQueryDAO getReadonlyQuery() {
        if (this.readonlyQuery == null) {
            this.readonlyQuery = MultiDataSetArchiverDataSourceUtil.getReadonlyQueryDAO();
        }
        return this.readonlyQuery;
    }

    IDataStoreServiceInternal getDataStoreService() {
        if (this.dataStoreService == null) {
            this.dataStoreService = ServiceProvider.getDataStoreService();
        }
        return this.dataStoreService;
    }

    IMultiDataSetArchiveCleaner getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = MultiDataSetArchivingUtils.createCleaner(this.cleanerProperties);
        }
        return this.cleaner;
    }

    ITimeAndWaitingProvider getTimeProvider() {
        if (this.timeProvider == null) {
            this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        }
        return this.timeProvider;
    }

    private static final class MultiDataSetProcessingStatuses
    extends AbstractArchiverProcessingPlugin.DatasetProcessingStatuses {
        private List<DatasetDescription> dataSetsWaitingForReplication;

        private MultiDataSetProcessingStatuses() {
        }

        public List<DatasetDescription> getDataSetsWaitingForReplication() {
            return this.dataSetsWaitingForReplication;
        }

        public void setDataSetsWaitingForReplication(List<DatasetDescription> dataSetsWaitingForReplication) {
            this.dataSetsWaitingForReplication = dataSetsWaitingForReplication;
        }

        public void addResults(MultiDataSetProcessingStatuses statuses) {
            super.addResults(statuses);
            this.dataSetsWaitingForReplication = statuses.getDataSetsWaitingForReplication();
        }
    }

    private static class MultiDataSetUnarchivingPreparations
    implements IUnarchivingPreparation {
        private final Share scratchShare;
        private final IEncapsulatedOpenBISService service;
        private final IShareIdManager shareIdManager;
        private final IDataSetDirectoryProvider directoryProvider;

        MultiDataSetUnarchivingPreparations(Share scratchShare, IShareIdManager shareIdManager, IEncapsulatedOpenBISService service, IDataSetDirectoryProvider directoryProvider) {
            this.shareIdManager = shareIdManager;
            this.service = service;
            this.scratchShare = scratchShare;
            this.directoryProvider = directoryProvider;
        }

        @Override
        public void prepareForUnarchiving(List<DatasetDescription> dataSets) {
            for (DatasetDescription dataSet : dataSets) {
                SimpleDataSetInformationDTO translatedDataSet = SimpleDataSetHelper.translate((DatasetDescription)dataSet);
                String dataSetCode = dataSet.getDataSetCode();
                translatedDataSet.setDataSetShareId(null);
                String oldShareId = this.shareIdManager.getShareId(dataSetCode);
                String newShareId = this.scratchShare.getShareId();
                if (newShareId.equals(oldShareId)) continue;
                this.service.updateShareIdAndSize(dataSetCode, newShareId, dataSet.getDataSetSize());
                this.shareIdManager.setShareId(dataSetCode, newShareId);
            }
            SegmentedStoreUtils.freeSpace(this.scratchShare, this.service, dataSets, this.directoryProvider, this.shareIdManager, (ISimpleLogger)new Log4jSimpleLogger(operationLog));
        }
    }

    private static enum FilterOption {
        FILTER_ARCHIVED,
        FILTER_UNARCHIVED;

    }

    private static class FileOperationsManagerFactory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Properties properties;
        private final ITimeAndWaitingProvider timeProvider;
        private IFreeSpaceProvider freeSpaceProviderOrNull;

        private FileOperationsManagerFactory(Properties properties, ITimeAndWaitingProvider timeProvider, IFreeSpaceProvider freeSpaceProviderOrNull) {
            this.properties = properties;
            this.timeProvider = timeProvider;
            this.freeSpaceProviderOrNull = freeSpaceProviderOrNull;
        }

        private IMultiDataSetFileOperationsManager create() {
            return new MultiDataSetFileOperationsManager(this.properties, new RsyncArchiveCopierFactory(), new SshCommandExecutorFactory(), this.freeSpaceProviderOrNull, this.timeProvider);
        }
    }
}

