/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiver;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class MultiDataSetArchivingUtils {
    MultiDataSetArchivingUtils() {
    }

    static IMultiDataSetArchiveCleaner createCleaner(Properties properties) {
        return new MultiDataSetArchiveCleaner(properties);
    }

    static Map<String, Status> sanityCheck(IHierarchicalContent archivedContent, List<DatasetDescription> dataSets, ArchiverTaskContext context, ISimpleLogger logger) {
        LinkedHashMap<String, Status> statuses = new LinkedHashMap<String, Status>();
        logger.log(LogLevel.INFO, "Start sanity check on " + CollectionUtils.abbreviate(dataSets, (int)10));
        for (DatasetDescription dataSet : dataSets) {
            String dataSetCode = dataSet.getDataSetCode();
            IHierarchicalContent content = null;
            try {
                content = context.getHierarchicalContentProvider().asContentWithoutModifyingAccessTimestamp(dataSetCode);
                IHierarchicalContentNode root = content.getRootNode();
                IHierarchicalContentNode archiveDataSetRoot = archivedContent.getNode(dataSetCode);
                Status status = RsyncArchiver.checkHierarchySizeAndChecksums(root, dataSetCode, archiveDataSetRoot, RsyncArchiver.ChecksumVerificationCondition.IF_AVAILABLE);
                if (status.isError()) {
                    throw new RuntimeException(status.tryGetErrorMessage());
                }
                statuses.put(dataSetCode, status);
            }
            catch (RuntimeException ex) {
                logger.log(LogLevel.ERROR, "Sanity check for data set " + dataSetCode + " failed: " + ex);
                throw ex;
            }
            finally {
                if (content == null) continue;
                content.close();
            }
        }
        logger.log(LogLevel.INFO, "Sanity check finished.");
        return statuses;
    }
}

