/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.DataSetUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.PhysicalDataUpdate;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.plugins.AbstractDataSetDeletionPostProcessingMaintenanceTaskWhichHandlesLastSeenEvent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiveCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.SshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetArchiveCleaner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchiver;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchivingUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverContainerDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSourceUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.MappingBasedShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiDataSetDeletionMaintenanceTask
extends AbstractDataSetDeletionPostProcessingMaintenanceTaskWhichHandlesLastSeenEvent {
    private static final String ARCHIVER_PREFIX = "archiver.";
    private static final String FINAL_DESTINATION_KEY = "archiver.final-destination";
    static final String LAST_SEEN_EVENT_ID_FILE = "last-seen-event-id-file";
    private List<Share> shares;
    private IShareFinder shareFinder;
    private IShareIdManager shareIdManager;
    private IApplicationServerApi v3;
    private IFreeSpaceProvider freeSpaceProvider;
    private MultiDataSetFileOperationsManager multiDataSetFileOperationsManager;
    private transient IMultiDataSetArchiveCleaner cleaner;
    private IDataSetDirectoryProvider dataSetDirectoryProvider;
    private IHierarchicalContentProvider hierarchicalContentProvider;
    private IMultiDataSetArchiverReadonlyQueryDAO readonlyQuery;
    private IDataStoreServiceInternal dataStoreService;
    private IConfigProvider configProvider;
    private Properties properties;
    private boolean hasReplication = false;

    @Override
    public void setUp(String pluginName, Properties properties) {
        super.setUp(pluginName, properties);
        this.properties = properties;
        this.dataSetDirectoryProvider = this.getDataStoreService().getDataSetDirectoryProvider();
        this.cleaner = MultiDataSetArchivingUtils.createCleaner(PropertyParametersUtil.extractSingleSectionProperties((Properties)properties, (String)"archiver.cleaner", (boolean)false).getProperties());
        String eventIdFileName = PropertyUtils.getMandatoryProperty((Properties)properties, (String)LAST_SEEN_EVENT_ID_FILE);
        this.lastSeenEventIdFile = new File(eventIdFileName);
        String finalDestination = properties.getProperty(FINAL_DESTINATION_KEY);
        if (finalDestination == null) {
            throw new ConfigurationFailureException("Missing property archiver.final-destination. Most likely reason: No " + MultiDataSetArchiver.class.getSimpleName() + " configured.");
        }
        properties.setProperty("final-destination", finalDestination);
        String replicatedDestination = properties.getProperty("archiver.replicated-destination");
        if (replicatedDestination != null) {
            this.hasReplication = true;
            properties.setProperty("replicated-destination", replicatedDestination);
        }
        this.shareFinder = properties.containsKey("mapping-file") ? new MappingBasedShareFinder(properties) : new FirstSuitableShareFinder();
        this.shares = this.getShares();
    }

    private List<Share> getShares() {
        IConfigProvider configProvider = this.getConfigProvider();
        File storeRoot = configProvider.getStoreRoot();
        String dataStoreCode = configProvider.getDataStoreCode();
        Set<String> idsOfIncomingShares = IncomingShareIdProvider.getIdsOfIncomingShares();
        return SegmentedStoreUtils.getSharesWithDataSets(storeRoot, dataStoreCode, SegmentedStoreUtils.FilterOptions.AVAILABLE_FOR_SHUFFLING, idsOfIncomingShares, this.getFreeSpaceProvider(), this.getOpenBISService(), this.getOperationLogAsSimpleLogger());
    }

    protected IMultiDataSetArchiverReadonlyQueryDAO getReadonlyQuery() {
        if (this.readonlyQuery == null) {
            this.readonlyQuery = MultiDataSetArchiverDataSourceUtil.getReadonlyQueryDAO();
        }
        return this.readonlyQuery;
    }

    protected IMultiDataSetArchiverDBTransaction getTransaction() {
        return new MultiDataSetArchiverDBTransaction();
    }

    protected IDataStoreServiceInternal getDataStoreService() {
        if (this.dataStoreService == null) {
            this.dataStoreService = ServiceProvider.getDataStoreService();
        }
        return this.dataStoreService;
    }

    protected IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    protected IApplicationServerApi getV3ApplicationService() {
        if (this.v3 == null) {
            this.v3 = ServiceProvider.getV3ApplicationService();
        }
        return this.v3;
    }

    protected IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    protected IConfigProvider getConfigProvider() {
        if (this.configProvider == null) {
            this.configProvider = ServiceProvider.getConfigProvider();
        }
        return this.configProvider;
    }

    protected MultiDataSetFileOperationsManager getMultiDataSetFileOperationsManager() {
        if (this.multiDataSetFileOperationsManager == null) {
            this.multiDataSetFileOperationsManager = new MultiDataSetFileOperationsManager(this.properties, new RsyncArchiveCopierFactory(), new SshCommandExecutorFactory(), this.getFreeSpaceProvider(), SystemTimeProvider.SYSTEM_TIME_PROVIDER);
        }
        return this.multiDataSetFileOperationsManager;
    }

    protected IFreeSpaceProvider getFreeSpaceProvider() {
        if (this.freeSpaceProvider == null) {
            this.freeSpaceProvider = new SimpleFreeSpaceProvider();
        }
        return this.freeSpaceProvider;
    }

    @Override
    protected void execute(List<DeletedDataSet> datasetCodes) {
        this.getOperationLogAsSimpleLogger().log(LogLevel.INFO, String.format("MultiDataSetDeletionMaintenanceTask has started processing data sets %s.", CollectionUtils.abbreviate((Collection)datasetCodes.stream().map(DeletedDataSet::getCode).collect(Collectors.toList()), (int)10)));
        List<MultiDataSetArchiverContainerDTO> containers = this.findArchivesWithDeletedDataSets(datasetCodes);
        Set codes = datasetCodes.stream().map(DeletedDataSet::getCode).collect(Collectors.toSet());
        for (MultiDataSetArchiverContainerDTO container : containers) {
            List<MultiDataSetArchiverDataSetDTO> dataSets = this.getReadonlyQuery().listDataSetsForContainerId(container.getId());
            ArrayList<SimpleDataSetInformationDTO> notDeletedDataSets = new ArrayList<SimpleDataSetInformationDTO>();
            for (MultiDataSetArchiverDataSetDTO dataSet : dataSets) {
                if (codes.contains(dataSet.getCode())) continue;
                SimpleDataSetInformationDTO simpleDataSet = this.getSimpleDataSet(dataSet);
                Share share = this.shareFinder.tryToFindShare(simpleDataSet, this.shares);
                if (share != null) {
                    this.getShareIdManager().setShareId(dataSet.getCode(), share.getShareId());
                    this.getOpenBISService().updateShareIdAndSize(dataSet.getCode(), share.getShareId(), dataSet.getSizeInBytes());
                    notDeletedDataSets.add(simpleDataSet);
                    continue;
                }
                throw EnvironmentFailureException.fromTemplate((String)"Unarchiving of data set '%s' has failed, because no appropriate destination share was found. Most probably there is not enough free space in the data store.", (Object[])new Object[]{dataSet.getCode()});
            }
            this.getOperationLogAsSimpleLogger().log(LogLevel.INFO, String.format("Container %s contains %d not deleted data sets.", container.getPath(), notDeletedDataSets.size()));
            if (!notDeletedDataSets.isEmpty()) {
                this.getOperationLogAsSimpleLogger().log(LogLevel.INFO, String.format("Not deleted data sets: %s.", CollectionUtils.abbreviate((Collection)notDeletedDataSets.stream().map(SimpleDataSetInformationDTO::getDataSetCode).collect(Collectors.toList()), (int)10)));
                this.getMultiDataSetFileOperationsManager().restoreDataSetsFromContainerInFinalDestination(container.getPath(), notDeletedDataSets);
                this.sanityCheck(notDeletedDataSets, container.getPath());
            }
            this.deleteContainer(container);
            this.getMultiDataSetFileOperationsManager().deleteContainerFromFinalDestination(this.cleaner, container.getPath());
            if (this.hasReplication) {
                this.getMultiDataSetFileOperationsManager().deleteContainerFromFinalReplicatedDestination(this.cleaner, container.getPath());
            }
            if (notDeletedDataSets.isEmpty()) continue;
            this.updateDataSetsStatusAndFlags(notDeletedDataSets);
        }
    }

    private List<DatasetDescription> convertToDataSetDescription(List<SimpleDataSetInformationDTO> notDeletedDataSets) {
        ArrayList<DatasetDescription> list = new ArrayList<DatasetDescription>();
        for (SimpleDataSetInformationDTO simpleDataSet : notDeletedDataSets) {
            DatasetDescription description = new DatasetDescription();
            description.setDataSetCode(simpleDataSet.getDataSetCode());
            list.add(description);
        }
        return list;
    }

    private void sanityCheck(List<SimpleDataSetInformationDTO> notDeletedDataSets, String containerPath) {
        List<DatasetDescription> dataSets = this.convertToDataSetDescription(notDeletedDataSets);
        IHierarchicalContent archivedContent = this.getMultiDataSetFileOperationsManager().getContainerAsHierarchicalContent(containerPath, dataSets);
        ArchiverTaskContext context = new ArchiverTaskContext(this.dataSetDirectoryProvider, this.getHierarchicalContentProvider());
        MultiDataSetArchivingUtils.sanityCheck(archivedContent, dataSets, context, this.getOperationLogAsSimpleLogger());
    }

    private void updateDataSetsStatusAndFlags(List<SimpleDataSetInformationDTO> notDeletedDataSets) {
        List<String> codes = notDeletedDataSets.stream().map(SimpleDataSetInformationDTO::getDataSetCode).collect(Collectors.toList());
        this.getOpenBISService().updateDataSetStatuses(codes, DataSetArchivingStatus.AVAILABLE, false);
        ArrayList<DataSetUpdate> dataSetUpdates = new ArrayList<DataSetUpdate>();
        for (String code : codes) {
            DataSetUpdate dataSetUpdate = new DataSetUpdate();
            dataSetUpdate.setDataSetId((IDataSetId)new DataSetPermId(code));
            PhysicalDataUpdate physicalDataUpdate = new PhysicalDataUpdate();
            physicalDataUpdate.setArchivingRequested(true);
            dataSetUpdate.setPhysicalData(physicalDataUpdate);
            dataSetUpdates.add(dataSetUpdate);
        }
        this.getV3ApplicationService().updateDataSets(this.getOpenBISService().getSessionToken(), dataSetUpdates);
    }

    private SimpleDataSetInformationDTO getSimpleDataSet(MultiDataSetArchiverDataSetDTO dataSet) {
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withPhysicalData();
        fetchOptions.withExperiment().withProject().withSpace();
        fetchOptions.withSample().withProject().withSpace();
        fetchOptions.withSample().withSpace();
        DataSetPermId dataSetPermId = new DataSetPermId(dataSet.getCode());
        DataSet dataSet1 = (DataSet)this.getV3ApplicationService().getDataSets(this.getOpenBISService().getSessionToken(), Arrays.asList(dataSetPermId), fetchOptions).get(dataSetPermId);
        SimpleDataSetInformationDTO simpleDataSet = new SimpleDataSetInformationDTO();
        simpleDataSet.setDataSetSize(dataSet1.getPhysicalData().getSize());
        simpleDataSet.setDataSetCode(dataSet1.getCode());
        simpleDataSet.setDataSetLocation(dataSet1.getPhysicalData().getLocation());
        if (dataSet1.getExperiment() != null) {
            simpleDataSet.setSpaceCode(dataSet1.getExperiment().getProject().getSpace().getCode());
            simpleDataSet.setProjectCode(dataSet1.getExperiment().getProject().getCode());
            simpleDataSet.setExperimentCode(dataSet1.getExperiment().getCode());
        } else {
            simpleDataSet.setSpaceCode(dataSet1.getSample().getSpace().getCode());
            if (dataSet1.getSample().getProject() != null) {
                simpleDataSet.setProjectCode(dataSet1.getSample().getProject().getCode());
            }
        }
        return simpleDataSet;
    }

    private void deleteContainer(MultiDataSetArchiverContainerDTO container) {
        IMultiDataSetArchiverDBTransaction transaction = this.getTransaction();
        try {
            transaction.deleteContainer(container.getId());
            transaction.commit();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        transaction.close();
        this.getOperationLogAsSimpleLogger().log(LogLevel.INFO, String.format("Container %s was successfully deleted from the database.", container.getPath()));
    }

    private List<MultiDataSetArchiverContainerDTO> findArchivesWithDeletedDataSets(List<DeletedDataSet> datasetCodes) {
        String[] dataSetCodes = (String[])datasetCodes.stream().map(DeletedDataSet::getCode).toArray(String[]::new);
        return this.getReadonlyQuery().listContainersWithDataSets(dataSetCodes);
    }

    private static class FirstSuitableShareFinder
    implements IShareFinder {
        private FirstSuitableShareFinder() {
        }

        @Override
        public Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares) {
            long dataSetSize = dataSet.getDataSetSize();
            dataSetSize += Math.max(1024L, Math.min(0x100000L, dataSet.getDataSetSize() / 10L));
            for (Share share : shares) {
                long freeSpace;
                if (share.isUnarchivingScratchShare() || (freeSpace = share.calculateFreeSpace()) <= dataSetSize) continue;
                return share;
            }
            return null;
        }
    }
}

