/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess;

import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverContainerDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSetDTO;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.Select;

public interface IMultiDataSetArchiverReadonlyQueryDAO
extends BaseQuery {
    public static final String SELECT_CONTAINER = " SELECT id, path, unarchiving_requested FROM containers ";
    public static final String SELECT_DATA_SET = " SELECT id, code, ctnr_id, size_in_bytes FROM data_sets ";

    @Select(sql=" SELECT id, path, unarchiving_requested FROM containers WHERE id = ?{1}")
    public MultiDataSetArchiverContainerDTO getContainerForId(long var1);

    @Select(sql=" SELECT id, path, unarchiving_requested FROM containers ")
    public List<MultiDataSetArchiverContainerDTO> listContainers();

    @Select(sql=" SELECT id, path, unarchiving_requested FROM containers WHERE unarchiving_requested = 't'")
    public List<MultiDataSetArchiverContainerDTO> listContainersForUnarchiving();

    @Select(sql=" SELECT id, path, unarchiving_requested FROM containers WHERE id in (select ctnr_id from data_sets where code = any(?{1}))", parameterBindings={StringArrayMapper.class})
    public List<MultiDataSetArchiverContainerDTO> listContainersWithDataSets(String[] var1);

    @Select(sql=" SELECT id, code, ctnr_id, size_in_bytes FROM data_sets WHERE id = ?{1}")
    public MultiDataSetArchiverDataSetDTO getDataSetForId(long var1);

    @Select(sql=" SELECT id, code, ctnr_id, size_in_bytes FROM data_sets WHERE code = ?{1}")
    public MultiDataSetArchiverDataSetDTO getDataSetForCode(String var1);

    @Select(sql=" SELECT id, code, ctnr_id, size_in_bytes FROM data_sets WHERE ctnr_id = ?{1}")
    public List<MultiDataSetArchiverDataSetDTO> listDataSetsForContainerId(long var1);

    @Select(sql="SELECT SUM(size_in_bytes) FROM data_sets, containers WHERE data_sets.ctnr_id = containers.id AND unarchiving_requested = 't'")
    public long getTotalNoOfBytesInContainersWithUnarchivingRequested();
}

