/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverContainerDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;

public class MultiDataSetArchiverDataSourceUtil {
    private static DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource("multi-dataset-archiver-db");

    static IMultiDataSetArchiverQueryDAO getTransactionalQuery() {
        return (IMultiDataSetArchiverQueryDAO)QueryTool.getQuery((DataSource)dataSource, IMultiDataSetArchiverQueryDAO.class);
    }

    public static IMultiDataSetArchiverReadonlyQueryDAO getReadonlyQueryDAO() {
        return (IMultiDataSetArchiverReadonlyQueryDAO)QueryTool.getQuery((DataSource)dataSource, IMultiDataSetArchiverReadonlyQueryDAO.class);
    }

    public static List<String> getContainerList() {
        List<MultiDataSetArchiverContainerDTO> containerDTOs = MultiDataSetArchiverDataSourceUtil.getReadonlyQueryDAO().listContainers();
        ArrayList<String> containers = new ArrayList<String>();
        if (containerDTOs != null) {
            for (MultiDataSetArchiverContainerDTO containerDTO : containerDTOs) {
                containers.add(containerDTO.getPath());
            }
        }
        return containers;
    }

    public static Boolean isDataSetInContainer(String dataSetCode) {
        MultiDataSetArchiverDataSetDTO dataSetDTO = MultiDataSetArchiverDataSourceUtil.getReadonlyQueryDAO().getDataSetForCode(dataSetCode);
        return dataSetDTO != null && dataSetDTO.getContainerId() > 0L;
    }
}

