/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServer;
import ch.systemsx.cisd.openbis.dss.generic.server.IServletPropertiesManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.ArchiverPluginFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.PluginTaskFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.PluginTaskProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchDomainService;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SessionWorkspaceUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatastoreServiceDescriptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PluginTaskInfoProvider
implements IPluginTaskInfoProvider {
    public static final String STOREROOT_DIR_KEY = "storeroot-dir";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PluginTaskInfoProvider.class);
    @Private
    static final String ARCHIVER_SECTION_NAME = "archiver";
    private final PluginTaskProvider<IReportingPluginTask> reportingPlugins;
    private final PluginTaskProvider<IProcessingPluginTask> processingPlugins;
    private final PluginTaskProvider<ISearchDomainService> sequenceDatabasePlugins;
    private final ArchiverPluginFactory archiverTaskFactory;
    private final File storeRoot;
    private final File sessionWorkspaceRootDir;

    public static IPluginTaskInfoProvider create() {
        ConfigParameters servletPropertiesManager = DataStoreServer.getConfigParameters();
        ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
        String storeRootDir = properties.getProperty(STOREROOT_DIR_KEY);
        File storeRoot = new File(storeRootDir);
        File workspaceRoot = SessionWorkspaceUtil.getSessionWorkspace((Properties)properties);
        PluginTaskInfoProvider providers = new PluginTaskInfoProvider((Properties)properties, servletPropertiesManager, storeRoot, workspaceRoot);
        providers.check();
        providers.logConfigurations();
        return providers;
    }

    @Private
    public PluginTaskInfoProvider(Properties serviceProperties, IServletPropertiesManager servletPropertiesManager, File storeRoot, File sessionWorkspaceRoot) {
        this.storeRoot = storeRoot;
        this.sessionWorkspaceRootDir = sessionWorkspaceRoot;
        String datastoreCode = DssPropertyParametersUtil.getDataStoreCode(serviceProperties);
        this.reportingPlugins = PluginTaskInfoProvider.createReportingPluginsFactories(serviceProperties, servletPropertiesManager, datastoreCode, storeRoot);
        this.processingPlugins = PluginTaskInfoProvider.createProcessingPluginsFactories(serviceProperties, servletPropertiesManager, datastoreCode, storeRoot);
        this.sequenceDatabasePlugins = PluginTaskInfoProvider.createPluginsFactories(serviceProperties, servletPropertiesManager, datastoreCode, storeRoot, ISearchDomainService.class, "Search domain service", "search-domain-services");
        this.archiverTaskFactory = this.createArchiverTaskFactory(serviceProperties, datastoreCode);
    }

    @Override
    public final File getStoreRoot() {
        return this.storeRoot;
    }

    @Override
    public File getSessionWorkspaceRootDir() {
        return this.sessionWorkspaceRootDir;
    }

    @Override
    public PluginTaskProvider<IReportingPluginTask> getReportingPluginsProvider() {
        return this.reportingPlugins;
    }

    @Override
    public PluginTaskProvider<IProcessingPluginTask> getProcessingPluginsProvider() {
        return this.processingPlugins;
    }

    @Override
    public PluginTaskProvider<ISearchDomainService> getSearchDomainServiceProvider() {
        return this.sequenceDatabasePlugins;
    }

    @Override
    public ArchiverPluginFactory getArchiverPluginFactory() {
        return this.archiverTaskFactory;
    }

    private void check() {
        this.processingPlugins.check(true);
        this.reportingPlugins.check(false);
        this.sequenceDatabasePlugins.check(false);
        this.archiverTaskFactory.check(this.storeRoot);
        operationLog.info((Object)("Session workspace root directory: " + this.sessionWorkspaceRootDir));
    }

    @Override
    public void logConfigurations() {
        this.processingPlugins.logConfigurations();
        this.reportingPlugins.logConfigurations();
        this.sequenceDatabasePlugins.logConfigurations();
        this.archiverTaskFactory.logConfiguration();
    }

    @Private
    static PluginTaskProvider<IReportingPluginTask> createReportingPluginsFactories(Properties serviceProperties, IServletPropertiesManager configParameters, String datastoreCode, File storeRoot) {
        return PluginTaskInfoProvider.createPluginsFactories(serviceProperties, configParameters, datastoreCode, storeRoot, IReportingPluginTask.class, "Reporting plugin", "reporting-plugins");
    }

    @Private
    static PluginTaskProvider<IProcessingPluginTask> createProcessingPluginsFactories(Properties serviceProperties, IServletPropertiesManager configParameters, String datastoreCode, File storeRoot) {
        return PluginTaskInfoProvider.createPluginsFactories(serviceProperties, configParameters, datastoreCode, storeRoot, IProcessingPluginTask.class, "Processing plugin", "processing-plugins");
    }

    private static <T> PluginTaskProvider<T> createPluginsFactories(Properties serviceProperties, IServletPropertiesManager configParameters, String datastoreCode, File storeRoot, Class<T> clazz, String pluginTaskName, String propertySectionName) {
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PluginTaskInfoProvider.extractSectionProperties(serviceProperties, propertySectionName);
        ArrayList factories = new ArrayList();
        for (PropertyParametersUtil.SectionProperties sectionProps : sectionsProperties) {
            factories.add(new PluginTaskFactory<T>(configParameters, sectionProps, datastoreCode, clazz, pluginTaskName, storeRoot));
        }
        return new PluginTaskProvider(factories);
    }

    private ArchiverPluginFactory createArchiverTaskFactory(Properties serviceProperties, String datastoreCode) {
        PropertyParametersUtil.SectionProperties sectionsProperties = PluginTaskInfoProvider.extractSingleSectionProperties(serviceProperties, ARCHIVER_SECTION_NAME);
        return new ArchiverPluginFactory(sectionsProperties);
    }

    private static PropertyParametersUtil.SectionProperties[] extractSectionProperties(Properties serviceProperties, String namesListPropertyKey) {
        return PropertyParametersUtil.extractSectionProperties((Properties)serviceProperties, (String)namesListPropertyKey, (boolean)false);
    }

    private static PropertyParametersUtil.SectionProperties extractSingleSectionProperties(Properties serviceProperties, String sectionName) {
        return PropertyParametersUtil.extractSingleSectionProperties((Properties)serviceProperties, (String)sectionName, (boolean)false);
    }

    @Override
    public DatastoreServiceDescriptions getPluginTaskDescriptions() {
        return new DatastoreServiceDescriptions(this.reportingPlugins.getPluginDescriptions(), this.processingPlugins.getPluginDescriptions());
    }
}

