/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.PluginTaskFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import java.util.ArrayList;
import java.util.List;

public class PluginTaskProvider<P> {
    private final TableMap<String, PluginTaskFactory<P>> factories;

    public PluginTaskProvider(List<PluginTaskFactory<P>> factories) {
        this.factories = new TableMap(factories, new IKeyExtractor<String, PluginTaskFactory<P>>(){

            public String getKey(PluginTaskFactory<P> factory) {
                return factory.getPluginDescription().getKey();
            }
        });
    }

    public P getPluginInstance(String pluginKey) {
        return this.getFactory(pluginKey).getPluginInstance();
    }

    public DatastoreServiceDescription getPluginDescription(String pluginKey) {
        return this.getFactory(pluginKey).getPluginDescription();
    }

    public List<DatastoreServiceDescription> getPluginDescriptions() {
        ArrayList<DatastoreServiceDescription> descriptions = new ArrayList<DatastoreServiceDescription>();
        for (PluginTaskFactory factory : this.factories.values()) {
            descriptions.add(factory.getPluginDescription());
        }
        return descriptions;
    }

    public void check(boolean checkIfSerializable) {
        for (PluginTaskFactory factory : this.factories.values()) {
            factory.check(checkIfSerializable);
        }
    }

    public void logConfigurations() {
        for (PluginTaskFactory factory : this.factories.values()) {
            factory.logConfiguration();
        }
    }

    private PluginTaskFactory<P> getFactory(String pluginKey) {
        PluginTaskFactory factory = (PluginTaskFactory)this.factories.tryGet((Object)pluginKey);
        if (factory == null) {
            throw new IllegalArgumentException("No plugin registered for key '" + pluginKey + "'.");
        }
        return factory;
    }
}

