/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.SpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.List;

public abstract class AbstractShareFinder
implements IShareFinder {
    @Override
    public Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares) {
        SpeedChecker[] values;
        for (SpeedChecker speedChecker : values = SpeedChecker.values()) {
            Share share = this.tryToFindShare(dataSet, shares, speedChecker);
            if (share == null) continue;
            this.assertSpeedChecker(dataSet, share, speedChecker);
            return share;
        }
        return null;
    }

    private void assertSpeedChecker(SimpleDataSetInformationDTO dataSet, Share share, SpeedChecker speedChecker) {
        if (!speedChecker.check(dataSet, share)) {
            throw new AssertionError((Object)("Found share " + share.getShareId() + " has speed " + share.getSpeed() + " but data set " + dataSet.getDataSetCode() + " has speed hint " + dataSet.getSpeedHint() + ". This violates speed checker " + speedChecker + "."));
        }
    }

    protected abstract Share tryToFindShare(SimpleDataSetInformationDTO var1, List<Share> var2, ISpeedChecker var3);
}

