/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetAwareHierarchicalContentNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.util.ArrayList;
import java.util.List;

public class DataSetAwareHierarchicalContent
implements IHierarchicalContent {
    private final IDatasetLocation dataSet;
    private final IHierarchicalContent content;

    public DataSetAwareHierarchicalContent(IDatasetLocation dataSet, IHierarchicalContent content) {
        this.dataSet = dataSet;
        this.content = content;
    }

    public IDatasetLocation getDataSet() {
        return this.dataSet;
    }

    public IHierarchicalContentNode getRootNode() {
        return DataSetAwareHierarchicalContent.decorate(this.dataSet, this.content.getRootNode());
    }

    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        return DataSetAwareHierarchicalContent.decorate(this.dataSet, this.content.getNode(relativePath));
    }

    public IHierarchicalContentNode tryGetNode(String relativePath) {
        return DataSetAwareHierarchicalContent.decorate(this.dataSet, this.content.tryGetNode(relativePath));
    }

    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        return DataSetAwareHierarchicalContent.decorate(this.dataSet, this.content.listMatchingNodes(relativePathPattern));
    }

    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        return DataSetAwareHierarchicalContent.decorate(this.dataSet, this.content.listMatchingNodes(startingPath, fileNamePattern));
    }

    public void close() {
        this.content.close();
    }

    static List<IHierarchicalContentNode> decorate(IDatasetLocation dataSet, List<IHierarchicalContentNode> nodes) {
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        for (IHierarchicalContentNode node : nodes) {
            result.add(DataSetAwareHierarchicalContent.decorate(dataSet, node));
        }
        return result;
    }

    private static IHierarchicalContentNode decorate(IDatasetLocation dataSet, IHierarchicalContentNode node) {
        return node == null ? null : new DataSetAwareHierarchicalContentNode(dataSet, node);
    }
}

