/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetAwareHierarchicalContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class DataSetAwareHierarchicalContentNode
implements IHierarchicalContentNode {
    private final IDatasetLocation dataSet;
    private final IHierarchicalContentNode node;

    public DataSetAwareHierarchicalContentNode(IDatasetLocation dataSet, IHierarchicalContentNode node) {
        this.dataSet = dataSet;
        this.node = node;
    }

    public IDatasetLocation getDataSet() {
        return this.dataSet;
    }

    public String getName() {
        return this.node.getName();
    }

    public String getRelativePath() {
        return this.node.getRelativePath();
    }

    public String getParentRelativePath() {
        return this.node.getParentRelativePath();
    }

    public boolean exists() {
        return this.node.exists();
    }

    public boolean isDirectory() {
        return this.node.isDirectory();
    }

    public long getLastModified() {
        return this.node.getLastModified();
    }

    public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
        return DataSetAwareHierarchicalContent.decorate(this.dataSet, this.node.getChildNodes());
    }

    public File getFile() throws UnsupportedOperationException {
        return this.node.getFile();
    }

    public File tryGetFile() {
        return this.node.tryGetFile();
    }

    public long getFileLength() throws UnsupportedOperationException {
        return this.node.getFileLength();
    }

    public int getChecksumCRC32() throws UnsupportedOperationException {
        return this.node.getChecksumCRC32();
    }

    public String getChecksum() throws UnsupportedOperationException {
        return this.node.getChecksum();
    }

    public boolean isChecksumCRC32Precalculated() {
        return this.node.isChecksumCRC32Precalculated();
    }

    public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
        return this.node.getFileContent();
    }

    public InputStream getInputStream() throws UnsupportedOperationException, IOExceptionUnchecked {
        return this.node.getInputStream();
    }
}

