/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.dbmigration.DBMigrationEngine;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDatabaseVersionHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSourceDefinition;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSourceWithDefinition;
import ch.systemsx.cisd.openbis.generic.shared.util.IDataSourceFactory;
import java.util.Properties;

public class DefaultDataSourceFactory
implements IDataSourceFactory {
    public static final String VERSION_HOLDER_CLASS_KEY = "version-holder-class";
    public static final String VERSION_KEY = "version";

    public DataSourceWithDefinition create(Properties dbProps) {
        DatabaseConfigurationContext context = (DatabaseConfigurationContext)BeanUtils.createBean(DatabaseConfigurationContext.class, (Object)dbProps);
        if (context.getBasicDatabaseName() == null) {
            throw new ConfigurationFailureException("db basic name not specified in " + dbProps);
        }
        if (context.getDatabaseEngineCode() == null) {
            throw new ConfigurationFailureException("db engine code not specified in " + dbProps);
        }
        String propertiesVersion = dbProps.getProperty(VERSION_KEY);
        if (propertiesVersion != null) {
            String version = propertiesVersion;
            DBMigrationEngine.createOrMigrateDatabaseAndGetScriptProvider((DatabaseConfigurationContext)context, (String)version, null);
        } else {
            String versionClass = dbProps.getProperty(VERSION_HOLDER_CLASS_KEY);
            if (versionClass != null) {
                IDatabaseVersionHolder versionHolder = (IDatabaseVersionHolder)ClassUtils.create(IDatabaseVersionHolder.class, (String)versionClass, (Object[])new Object[0]);
                String version = versionHolder.getDatabaseVersion();
                DBMigrationEngine.createOrMigrateDatabaseAndGetScriptProvider((DatabaseConfigurationContext)context, (String)version, null);
            }
        }
        return new DataSourceWithDefinition(context.getDataSource(), DataSourceDefinition.createFromContext((DatabaseConfigurationContext)context));
    }
}

