/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.ManagedAuthentication;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IEncapsulatedBasicOpenBISService {
    @ManagedAuthentication
    public Space tryGetSpace(SpaceIdentifier var1) throws UserFailureException;

    @ManagedAuthentication
    public Project tryGetProject(ProjectIdentifier var1) throws UserFailureException;

    @ManagedAuthentication
    public DataSetTypeWithVocabularyTerms getDataSetType(String var1);

    @ManagedAuthentication
    public AbstractExternalData tryGetDataSet(String var1) throws UserFailureException;

    @ManagedAuthentication
    public AbstractExternalData tryGetThinDataSet(String var1) throws UserFailureException;

    @ManagedAuthentication
    public AbstractExternalData tryGetLocalDataSet(String var1) throws UserFailureException;

    @ManagedAuthentication
    public List<Sample> searchForSamples(SearchCriteria var1);

    @ManagedAuthentication
    public List<Experiment> searchForExperiments(SearchCriteria var1);

    @ManagedAuthentication
    public Sample tryGetSampleWithExperiment(SampleIdentifier var1) throws UserFailureException;

    @ManagedAuthentication
    public List<AbstractExternalData> searchForDataSets(SearchCriteria var1);

    @ManagedAuthentication
    public List<Experiment> listExperiments(ProjectIdentifier var1);

    @ManagedAuthentication
    public Experiment tryGetExperiment(ExperimentIdentifier var1) throws UserFailureException;

    @ManagedAuthentication
    public Collection<VocabularyTerm> listVocabularyTerms(String var1) throws UserFailureException;

    @ManagedAuthentication
    public Vocabulary tryGetVocabulary(String var1);

    @ManagedAuthentication
    public List<Material> listMaterials(ListMaterialCriteria var1, boolean var2);

    @ManagedAuthentication
    public Material tryGetMaterial(MaterialIdentifier var1);

    @ManagedAuthentication
    public List<? extends EntityTypePropertyType<?>> listPropertyDefinitionsForEntityType(String var1, EntityKind var2);

    @ManagedAuthentication
    public List<Metaproject> listMetaprojects();

    @ManagedAuthentication
    public Metaproject tryGetMetaproject(String var1);

    @ManagedAuthentication
    public MetaprojectAssignments getMetaprojectAssignments(String var1);

    @ManagedAuthentication
    public List<Metaproject> listMetaprojectsForEntity(IObjectId var1);

    @ManagedAuthentication
    public Map<IObjectId, List<Metaproject>> listMetaprojectsForEntities(Collection<? extends IObjectId> var1);

    @ManagedAuthentication
    public Project tryGetProjectByPermId(String var1) throws UserFailureException;

    @ManagedAuthentication
    public Experiment tryGetExperimentByPermId(String var1) throws UserFailureException;

    @ManagedAuthentication
    public Sample tryGetSampleByPermId(String var1) throws UserFailureException;

    @ManagedAuthentication
    public String getSessionToken();
}

