/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiveFolders;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import com.csvreader.CsvReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class IdentifierAttributeMappingManager {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, IdentifierAttributeMappingManager.class);
    private List<Attributes> attributesList = new ArrayList<Attributes>();
    private final boolean createArchives;
    private final File mappingFileOrNull;
    private long mappingFileLastModified;
    private Long smallDataSetsSizeLimit;

    public IdentifierAttributeMappingManager(String mappingFilePathOrNull, boolean createArchives, Long smallDataSetsSizeLimit) {
        this.createArchives = createArchives;
        this.smallDataSetsSizeLimit = smallDataSetsSizeLimit;
        if (StringUtils.isBlank((CharSequence)mappingFilePathOrNull)) {
            this.mappingFileOrNull = null;
        } else {
            this.mappingFileOrNull = new File(mappingFilePathOrNull);
            if (!this.mappingFileOrNull.exists()) {
                throw new IllegalArgumentException("Mapping file '" + this.mappingFileOrNull + "' does not exist.");
            }
            this.getAttributesList();
        }
    }

    private List<Attributes> getAttributesList() {
        long lastModified;
        if (this.mappingFileOrNull != null && (lastModified = this.mappingFileOrNull.lastModified()) != this.mappingFileLastModified) {
            this.attributesList = this.loadMappingFile(this.mappingFileOrNull);
            this.mappingFileLastModified = lastModified;
        }
        return this.attributesList;
    }

    private List<Attributes> loadMappingFile(File mappingFile) {
        ArrayList<Attributes> newAttributesList = new ArrayList<Attributes>();
        try (CsvReader reader = null;){
            reader = new CsvReader(mappingFile.getPath(), '\t');
            reader.setSkipEmptyRecords(true);
            reader.setUseComments(false);
            reader.setComment('#');
            reader.setTrimWhitespace(true);
            boolean success = reader.readHeaders();
            if (!success) {
                throw new IllegalArgumentException("Empty mapping file: " + mappingFile);
            }
            while (reader.readRecord()) {
                String[] row = reader.getValues();
                if (this.isEmptyRow(row)) continue;
                if (row.length != 3) {
                    throw new IllegalArgumentException("Invalid number of row elements in mapping file '" + mappingFile + "': " + Arrays.asList(row));
                }
                Pattern identifierPattern = this.getIdentifierPattern(row[0]);
                List<String> shareIds = this.getShareIds(row[1]);
                ArchiveFolders archiveFolders = this.getArchiveFolder(row[2]);
                Attributes attributes = new Attributes(identifierPattern, shareIds, archiveFolders);
                newAttributesList.add(attributes);
            }
            this.attributesList = newAttributesList;
            operationLog.info((Object)("Mapping file '" + mappingFile + "' successfully loaded."));
            ArrayList<Attributes> arrayList = newAttributesList;
            return arrayList;
        }
    }

    private boolean isEmptyRow(String[] row) {
        for (String cell : row) {
            if (cell.length() <= 0) continue;
            return false;
        }
        return true;
    }

    private Pattern getIdentifierPattern(String regex) {
        return Pattern.compile(StringUtils.isBlank((CharSequence)regex) ? ".*" : regex.toUpperCase());
    }

    private ArchiveFolders getArchiveFolder(String folders) {
        if (StringUtils.isBlank((CharSequence)folders)) {
            return null;
        }
        String[] folderPaths = folders.split(",");
        return ArchiveFolders.create(folderPaths, this.createArchives, this.smallDataSetsSizeLimit);
    }

    private List<String> getShareIds(String shareIds) {
        String[] splittedIds;
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)shareIds)) {
            return ids;
        }
        for (String id : splittedIds = shareIds.split(",")) {
            ids.add(id.trim());
        }
        return ids;
    }

    public Collection<File> getAllFolders() {
        HashSet<File> folders = new HashSet<File>();
        for (Attributes attributes : this.getAttributesList()) {
            ArchiveFolders archiveFolders = attributes.getArchiveFolders();
            if (archiveFolders == null) continue;
            for (File archiveFolder : archiveFolders.getAllFolders()) {
                if (archiveFolder == null || !archiveFolder.exists()) continue;
                folders.add(archiveFolder);
            }
        }
        return folders;
    }

    public File getArchiveFolder(DatasetDescription dataSetDescription, File defaultFolder) {
        String experimentCode;
        String projectCode;
        String spaceCode = dataSetDescription.getSpaceCode();
        Attributes attributes = this.tryGetExperimentAttributes(spaceCode, projectCode = dataSetDescription.getProjectCode(), experimentCode = dataSetDescription.getExperimentCode());
        if (this.hasArchiveFolder(dataSetDescription, attributes)) {
            return attributes.getArchiveFolders().getFolder(dataSetDescription);
        }
        attributes = this.tryGetProjectAttributes(spaceCode, projectCode);
        if (this.hasArchiveFolder(dataSetDescription, attributes)) {
            return attributes.getArchiveFolders().getFolder(dataSetDescription);
        }
        attributes = this.tryGetSpaceAttributes(spaceCode);
        if (this.hasArchiveFolder(dataSetDescription, attributes)) {
            return attributes.getArchiveFolders().getFolder(dataSetDescription);
        }
        return defaultFolder;
    }

    private boolean hasArchiveFolder(DatasetDescription dataSetDescription, Attributes attributes) {
        return attributes != null && attributes.getArchiveFolders() != null && attributes.getArchiveFolders().getFolder(dataSetDescription) != null;
    }

    public List<String> getShareIds(SimpleDataSetInformationDTO dataSet) {
        String experimentCode;
        String projectCode;
        String spaceCode = dataSet.getSpaceCode();
        Attributes attributes = this.tryGetExperimentAttributes(spaceCode, projectCode = dataSet.getProjectCode(), experimentCode = dataSet.getExperimentCode());
        if (this.hasShareIds(attributes)) {
            return attributes.getShareIds();
        }
        attributes = this.tryGetProjectAttributes(spaceCode, projectCode);
        if (this.hasShareIds(attributes)) {
            return attributes.getShareIds();
        }
        attributes = this.tryGetSpaceAttributes(spaceCode);
        if (this.hasShareIds(attributes)) {
            return attributes.getShareIds();
        }
        return Collections.emptyList();
    }

    private boolean hasShareIds(Attributes attributes) {
        if (attributes == null) {
            return false;
        }
        List<String> shareIds = attributes.getShareIds();
        return shareIds != null && !shareIds.isEmpty();
    }

    private Attributes tryGetExperimentAttributes(String spaceCode, String projectCode, String experimentCode) {
        if (experimentCode == null) {
            return null;
        }
        String identifier = new ExperimentIdentifier(spaceCode, projectCode, experimentCode).toString();
        return this.tryGetAttributes(identifier);
    }

    private Attributes tryGetProjectAttributes(String spaceCode, String projectCode) {
        if (projectCode == null) {
            return null;
        }
        String identifier = new ProjectIdentifier(spaceCode, projectCode).toString();
        return this.tryGetAttributes(identifier);
    }

    private Attributes tryGetSpaceAttributes(String spaceCode) {
        return this.tryGetAttributes(new SpaceIdentifier(spaceCode).toString());
    }

    private Attributes tryGetAttributes(String identifier) {
        for (Attributes attributes : this.getAttributesList()) {
            if (!attributes.getIdentifierPattern().matcher(identifier).matches()) continue;
            return attributes;
        }
        return null;
    }

    private static final class Attributes {
        private final Pattern identifierPattern;
        private final ArchiveFolders archiveFolders;
        private final List<String> shareIds;

        Attributes(Pattern identifierPattern, List<String> shareIds, ArchiveFolders archiveFolders) {
            this.identifierPattern = identifierPattern;
            this.shareIds = shareIds;
            this.archiveFolders = archiveFolders;
        }

        public Pattern getIdentifierPattern() {
            return this.identifierPattern;
        }

        public List<String> getShareIds() {
            return this.shareIds;
        }

        public ArchiveFolders getArchiveFolders() {
            return this.archiveFolders;
        }
    }
}

