/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.IdentifierAttributeMappingManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class MappingBasedShareFinder
implements IShareFinder {
    public static final String MAPPING_FILE_KEY = "mapping-file";
    private IdentifierAttributeMappingManager mapping;

    public MappingBasedShareFinder(Properties properties) {
        String mappingFilePath = PropertyUtils.getMandatoryProperty((Properties)properties, (String)MAPPING_FILE_KEY);
        this.mapping = new IdentifierAttributeMappingManager(mappingFilePath, false, null);
    }

    @Override
    public Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares) {
        HashMap<String, Share> shareId2Shares = new HashMap<String, Share>();
        for (Share share : shares) {
            if (share.calculateFreeSpace() <= dataSet.getDataSetSize()) continue;
            shareId2Shares.put(share.getShareId(), share);
        }
        List<String> shareIds = this.mapping.getShareIds(dataSet);
        for (String shareId : shareIds) {
            Share share = (Share)shareId2Shares.get(shareId);
            if (share == null) continue;
            return share;
        }
        return null;
    }
}

