/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.dssapi.v3.IDataStoreServerApi;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSourceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IContentCache;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.spring.JsonServiceExporter;
import com.marathon.util.spring.StreamSupportingHttpInvokerServiceExporter;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;

public class ServiceProvider {
    public static final String DATA_STORE_SERVICE_BEAN = "data-store-service";
    public static final String SHARE_ID_MANAGER_BEAN = "share-id-manager";
    public static final String CONFIG_PROVIDER_BEAN = "config-provider";
    public static final String OPEN_BIS_SERVICE_BEAN = "openBIS-service";
    public static final String V3_APPLICATION_SERVICE_BEAN = "v3-application-service";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ServiceProvider.class);
    private static BeanFactory applicationContext = null;
    public static final Date DSS_STARTUP_DATE = new Date();
    private static boolean buildingApplicationContext;

    @Deprecated
    public static void setBeanFactory(BeanFactory applicationContext) {
        ServiceProvider.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BeanFactory tryGetApplicationContext(boolean create) {
        if (!create || applicationContext != null) return applicationContext;
        Class<ServiceProvider> clazz = ServiceProvider.class;
        synchronized (ServiceProvider.class) {
            if (applicationContext != null) return applicationContext;
            if (buildingApplicationContext) {
                throw new IllegalStateException("Building application context. Application context hasn't been built completely. Beans should access other beans lazily.");
            }
            buildingApplicationContext = true;
            applicationContext = new ClassPathXmlApplicationContext(new String[]{"dssApplicationContext.xml"}, true){
                {
                    this.setDisplayName("Application Context from { dssApplicationContext.xml }");
                }
            };
            buildingApplicationContext = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return applicationContext;
        }
    }

    public static BeanFactory getApplicationContext() {
        return ServiceProvider.tryGetApplicationContext(true);
    }

    public static IServiceForDataStoreServer getServiceForDSS() {
        return (IServiceForDataStoreServer)ServiceProvider.getApplicationContext().getBean("etl-lims-service");
    }

    public static IEncapsulatedOpenBISService getOpenBISService() {
        return (IEncapsulatedOpenBISService)ServiceProvider.getApplicationContext().getBean(OPEN_BIS_SERVICE_BEAN);
    }

    public static IApplicationServerApi getV3ApplicationService() {
        return (IApplicationServerApi)ServiceProvider.getApplicationContext().getBean(V3_APPLICATION_SERVICE_BEAN);
    }

    public static IDataStoreServerApi getV3DataStoreService() {
        return (IDataStoreServerApi)ServiceProvider.getApplicationContext().getBean("data-store-server_INTERNAL");
    }

    public static IGeneralInformationService getGeneralInformationService() {
        return (IGeneralInformationService)ServiceProvider.getApplicationContext().getBean("general-information-service");
    }

    public static IDataSetPathInfoProvider getDataSetPathInfoProvider() {
        return (IDataSetPathInfoProvider)ServiceProvider.getApplicationContext().getBean("data-set-path-infos-provider");
    }

    public static HttpInvokerServiceExporter getServiceConversationClientManagerServer() {
        return (HttpInvokerServiceExporter)ServiceProvider.getApplicationContext().getBean("data-store-service-conversation-client-manager-server");
    }

    public static HttpInvokerServiceExporter getServiceConversationServerManagerServer() {
        return (HttpInvokerServiceExporter)ServiceProvider.getApplicationContext().getBean("data-store-service-conversation-server-manager-server");
    }

    public static IShareIdManager getShareIdManager() {
        return (IShareIdManager)ServiceProvider.getApplicationContext().getBean(SHARE_ID_MANAGER_BEAN);
    }

    public static IHierarchicalContentProvider getHierarchicalContentProvider() {
        return (IHierarchicalContentProvider)ServiceProvider.getApplicationContext().getBean("hierarchical-content-provider");
    }

    public static HttpInvokerServiceExporter getDataStoreServer() {
        return (HttpInvokerServiceExporter)ServiceProvider.getApplicationContext().getBean("data-store-server");
    }

    public static HttpInvokerServiceExporter getRpcNameServiceExporter() {
        return (HttpInvokerServiceExporter)ServiceProvider.getApplicationContext().getBean("data-store-rpc-name-server");
    }

    public static StreamSupportingHttpInvokerServiceExporter getDssServiceRpcGeneric() {
        return (StreamSupportingHttpInvokerServiceExporter)ServiceProvider.getApplicationContext().getBean("data-store-rpc-service-generic");
    }

    public static IDataStoreServerApi getDssServiceInternalV3() {
        return (IDataStoreServerApi)ServiceProvider.getApplicationContext().getBean("data-store-server_INTERNAL");
    }

    public static HttpInvokerServiceExporter getDssServiceV3() {
        return (HttpInvokerServiceExporter)ServiceProvider.getApplicationContext().getBean("v3-exporter");
    }

    public static JsonServiceExporter getDssServiceJsonV3() {
        return (JsonServiceExporter)ServiceProvider.getApplicationContext().getBean("v3-exporter-json");
    }

    public static ObjectMapper getObjectMapperV1() {
        return (ObjectMapper)ServiceProvider.getApplicationContext().getBean("objectMapper-v1");
    }

    public static ObjectMapper getObjectMapperV3() {
        return (ObjectMapper)ServiceProvider.getApplicationContext().getBean("objectMapper-v3");
    }

    public static IDataSourceProvider getDataSourceProvider() {
        return (IDataSourceProvider)ServiceProvider.getApplicationContext().getBean("data-source-provider");
    }

    public static IConfigProvider getConfigProvider() {
        return (IConfigProvider)ServiceProvider.getApplicationContext().getBean(CONFIG_PROVIDER_BEAN);
    }

    public static OpenBISSessionHolder getSessionHolder() {
        return (OpenBISSessionHolder)ServiceProvider.getApplicationContext().getBean("sessionHolder");
    }

    public static IDataStoreServiceInternal getDataStoreService() {
        Object bean = ServiceProvider.getApplicationContext().getBean(DATA_STORE_SERVICE_BEAN);
        IDataStoreServiceInternal result = null;
        if (bean instanceof Advised) {
            Advised advised = (Advised)ServiceProvider.getApplicationContext().getBean(DATA_STORE_SERVICE_BEAN);
            try {
                result = (IDataStoreServiceInternal)advised.getTargetSource().getTarget();
            }
            catch (Exception ex) {
                operationLog.error((Object)("Cannot get IDataSetDeleter instance :" + ex.getMessage()), (Throwable)ex);
            }
        } else {
            result = (IDataStoreServiceInternal)bean;
        }
        return result;
    }

    public static IContentCache getContentCache() {
        return (IContentCache)ServiceProvider.getApplicationContext().getBean("content-cache");
    }

    private ServiceProvider() {
    }
}

