/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.dss.generic.shared.ISpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;

public enum SpeedChecker implements ISpeedChecker
{
    MATCHING_CHECKER{

        @Override
        public boolean check(SimpleDataSetInformationDTO dataSet, Share share) {
            return Math.abs(dataSet.getSpeedHint()) == share.getSpeed();
        }
    }
    ,
    RESPECTING_SPEED_HINT_CHECKER{

        @Override
        public boolean check(SimpleDataSetInformationDTO dataSet, Share share) {
            int speedHint = dataSet.getSpeedHint();
            int speed = share.getSpeed();
            return speedHint < 0 ? speed < Math.abs(speedHint) : speed > speedHint;
        }
    }
    ,
    IGNORING_SPEED_HINT_CHECKER{

        @Override
        public boolean check(SimpleDataSetInformationDTO dataSet, Share share) {
            return true;
        }
    };

}

