/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.DssSessionAuthorizationHolder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.authorization.IAuthorizationGuardPredicate;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import java.util.Arrays;
import java.util.List;

public class NewDataSetPredicate
implements IAuthorizationGuardPredicate<IDssServiceRpcGeneric, NewDataSetDTO> {
    @Override
    public List<String> getDataSetCodes(NewDataSetDTO argument) {
        return Arrays.asList(new String[0]);
    }

    @Override
    public Status evaluate(IDssServiceRpcGeneric receiver, String sessionToken, NewDataSetDTO newDataSet) throws UserFailureException {
        if (newDataSet == null) {
            throw new UserFailureException("New data set cannot be null");
        }
        NewDataSetDTO.DataSetOwner owner = newDataSet.getDataSetOwner();
        if (owner == null) {
            throw new UserFailureException("Owner of a new data set cannot be null");
        }
        String ownerIdentifier = owner.getIdentifier();
        if (ownerIdentifier == null) {
            throw new UserFailureException("Owner identifier of a new data set cannot be null");
        }
        switch (owner.getType()) {
            case EXPERIMENT: {
                return DssSessionAuthorizationHolder.getAuthorizer().checkExperimentWriteable(sessionToken, ownerIdentifier);
            }
            case SAMPLE: {
                return DssSessionAuthorizationHolder.getAuthorizer().checkSampleWriteable(sessionToken, ownerIdentifier);
            }
            case DATA_SET: {
                return DssSessionAuthorizationHolder.getAuthorizer().checkDatasetAccess(sessionToken, ownerIdentifier);
            }
        }
        return null;
    }
}

