/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class NewDataSetMetadataDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<String> unmodifiableProperties = new HashSet<String>();
    private String dataSetTypeOrNull;
    private final ArrayList<String> parentDataSetCodes = new ArrayList();

    public NewDataSetMetadataDTO(String dataSetTypeOrNull, Map<String, String> propertiesOrNull) {
        this(dataSetTypeOrNull, propertiesOrNull, null);
    }

    public NewDataSetMetadataDTO(String dataSetTypeOrNull, Map<String, String> propertiesOrNull, List<String> parentDataSetCodesOrNull) {
        this.dataSetTypeOrNull = dataSetTypeOrNull;
        this.setProperties(propertiesOrNull);
        this.setParentDataSetCodes(parentDataSetCodesOrNull);
    }

    public NewDataSetMetadataDTO() {
        this(null, null);
    }

    public String tryDataSetType() {
        return this.dataSetTypeOrNull;
    }

    public void setDataSetTypeOrNull(String dataSetTypeOrNull) {
        this.dataSetTypeOrNull = dataSetTypeOrNull != null ? dataSetTypeOrNull.toUpperCase() : null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<String> getUnmodifiableProperties() {
        return this.unmodifiableProperties;
    }

    public void setProperties(Map<String, String> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public void setUnmodifiableProperties(Set<String> props) {
        this.unmodifiableProperties.clear();
        if (props != null) {
            this.unmodifiableProperties.addAll(props);
        }
    }

    public void setUnmodifiableProperties(Map<String, String> props) {
        this.setProperties(props);
        this.setUnmodifiableProperties(props.keySet());
    }

    public boolean isUnmodifiableProperty(String property) {
        return this.unmodifiableProperties.contains(property);
    }

    public List<String> getParentDataSetCodes() {
        return Collections.unmodifiableList(this.parentDataSetCodes);
    }

    public void setParentDataSetCodes(List<String> codesOrNull) {
        this.parentDataSetCodes.clear();
        if (codesOrNull != null) {
            this.parentDataSetCodes.addAll(codesOrNull);
        }
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        String myDataSetTypeOrNull = this.tryDataSetType();
        if (null != myDataSetTypeOrNull) {
            sb.append("data set type", (Object)myDataSetTypeOrNull);
        }
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            sb.append("property " + entry.getKey(), (Object)entry.getValue());
        }
        return sb.toString();
    }
}

