/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.PathInfoProviderBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import java.io.File;

public class PathInfoDBOnlyHierarchicalContentFactory
extends DefaultFileBasedHierarchicalContentFactory {
    private final IDataSetPathInfoProvider pathInfoProvider;

    public static IHierarchicalContentFactory create() {
        if (PathInfoDataSourceProvider.isDataSourceDefined()) {
            return new PathInfoDBOnlyHierarchicalContentFactory(ServiceProvider.getDataSetPathInfoProvider());
        }
        return null;
    }

    @Private
    PathInfoDBOnlyHierarchicalContentFactory(IDataSetPathInfoProvider pathInfoProvider) {
        this.pathInfoProvider = pathInfoProvider;
    }

    public IHierarchicalContent asHierarchicalContent(File file, IDelegatedAction onCloseAction) {
        String dataSetCode = file.getName();
        ISingleDataSetPathInfoProvider dataSetPathInfoProvider = this.pathInfoProvider.tryGetSingleDataSetPathInfoProvider(dataSetCode);
        if (dataSetPathInfoProvider != null) {
            return new PathInfoProviderBasedHierarchicalContent(dataSetPathInfoProvider, file, onCloseAction);
        }
        return null;
    }
}

