/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IFileContentProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class PathInfoProviderBasedHierarchicalContent
implements IHierarchicalContent {
    private final File root;
    private final IDelegatedAction onCloseAction;
    private IHierarchicalContentNode rootNode;
    private final ISingleDataSetPathInfoProvider dataSetPathInfoProvider;

    public PathInfoProviderBasedHierarchicalContent(ISingleDataSetPathInfoProvider dataSetPathInfoProvider, File dataSetDir, IDelegatedAction onCloseAction) {
        assert (dataSetPathInfoProvider != null);
        this.dataSetPathInfoProvider = dataSetPathInfoProvider;
        this.onCloseAction = onCloseAction;
        this.root = dataSetDir;
    }

    public IHierarchicalContentNode getRootNode() {
        if (this.rootNode == null) {
            DataSetPathInfo pathInfo = this.dataSetPathInfoProvider.getRootPathInfo();
            this.rootNode = this.asNode(pathInfo);
        }
        return this.rootNode;
    }

    public IHierarchicalContentNode getNode(String relativePath) {
        IHierarchicalContentNode nodeOrNull = this.tryGetNode(relativePath);
        if (nodeOrNull == null) {
            throw new IllegalArgumentException("Resource '" + relativePath + "' does not exist.");
        }
        return nodeOrNull;
    }

    public IHierarchicalContentNode tryGetNode(String relativePath) {
        if (StringUtils.isBlank((String)relativePath)) {
            return this.getRootNode();
        }
        DataSetPathInfo pathInfoOrNull = this.dataSetPathInfoProvider.tryGetPathInfoByRelativePath(relativePath);
        if (pathInfoOrNull == null) {
            return null;
        }
        return this.asNode(pathInfoOrNull);
    }

    private IHierarchicalContentNode asNode(DataSetPathInfo pathInfo) {
        return new PathInfoNode(pathInfo);
    }

    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        List<DataSetPathInfo> matchingPathInfos = this.dataSetPathInfoProvider.listMatchingPathInfos(relativePathPattern);
        for (DataSetPathInfo pathInfo : matchingPathInfos) {
            result.add(this.asNode(pathInfo));
        }
        return result;
    }

    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        List<DataSetPathInfo> matchingPathInfos = this.dataSetPathInfoProvider.listMatchingPathInfos(startingPath, fileNamePattern);
        for (DataSetPathInfo pathInfo : matchingPathInfos) {
            result.add(this.asNode(pathInfo));
        }
        return result;
    }

    public void close() {
        this.onCloseAction.execute();
    }

    public String toString() {
        return "PathInfoProviderBasedHierarchicalContent [root=" + this.root + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathInfoProviderBasedHierarchicalContent)) {
            return false;
        }
        PathInfoProviderBasedHierarchicalContent other = (PathInfoProviderBasedHierarchicalContent)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    private IFileContentProvider getFileContentProvider(File file) {
        File existingFile;
        if (file.exists()) {
            return PathInfoProviderBasedHierarchicalContent.asFileContentProvider(file);
        }
        for (existingFile = file; existingFile != null && !existingFile.exists(); existingFile = existingFile.getParentFile()) {
        }
        if (existingFile != null && FileUtilities.isHDF5ContainerFile((File)existingFile)) {
            String relativePath = FileUtilities.getRelativeFilePath((File)existingFile, (File)file);
            return new HDF5ContainerBasedHierarchicalContentNode.HDF5DataSetBasedContent(existingFile, relativePath);
        }
        throw new IllegalArgumentException("Resource '" + FileUtilities.getRelativeFilePath((File)this.root, (File)file) + "' is currently unavailable. It might be archived.");
    }

    private static IFileContentProvider asFileContentProvider(final File existingFile) {
        assert (existingFile.exists());
        return new IFileContentProvider(){

            public IRandomAccessFile getReadOnlyRandomAccessFile() {
                return new RandomAccessFileImpl(existingFile, "r");
            }

            public InputStream getInputStream() {
                try {
                    return new FileInputStream(existingFile);
                }
                catch (FileNotFoundException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        };
    }

    class PathInfoNode
    extends AbstractHierarchicalContentNode {
        private final DataSetPathInfo pathInfo;
        private IFileContentProvider fileContentProviderOrNull;

        PathInfoNode(DataSetPathInfo pathInfo) {
            this.pathInfo = pathInfo;
        }

        public String getName() {
            return this.pathInfo.getFileName();
        }

        public boolean exists() {
            return true;
        }

        protected boolean isPhysicalFile() {
            File file = this.doGetFile();
            return file.isFile();
        }

        public boolean isDirectory() {
            return this.pathInfo.isDirectory();
        }

        public long getLastModified() {
            return this.pathInfo.getLastModified().getTime();
        }

        protected String doGetRelativePath() {
            return this.pathInfo.getRelativePath();
        }

        protected List<IHierarchicalContentNode> doGetChildNodes() {
            ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
            List<DataSetPathInfo> pathInfos = PathInfoProviderBasedHierarchicalContent.this.dataSetPathInfoProvider.listChildrenPathInfos(this.pathInfo);
            if (pathInfos != null) {
                for (DataSetPathInfo child : pathInfos) {
                    result.add(PathInfoProviderBasedHierarchicalContent.this.asNode(child));
                }
            }
            return result;
        }

        protected long doGetFileLength() {
            return this.pathInfo.getSizeInBytes();
        }

        protected int doGetChecksumCRC32() {
            Integer checksumCRC32 = this.pathInfo.getChecksumCRC32();
            if (checksumCRC32 != null) {
                return checksumCRC32;
            }
            return IOUtilities.getChecksumCRC32((InputStream)this.getInputStream());
        }

        protected String doGetChecksum() {
            return this.pathInfo.getChecksum();
        }

        public boolean isChecksumCRC32Precalculated() {
            return this.pathInfo.getChecksumCRC32() != null;
        }

        public File getFile() throws UnsupportedOperationException {
            File result = this.doGetFile();
            if (result.exists()) {
                return result;
            }
            throw new UnsupportedOperationException("This is not a normal file/directory node: " + result);
        }

        public File tryGetFile() {
            File result = this.doGetFile();
            if (result.exists()) {
                return result;
            }
            return null;
        }

        protected IRandomAccessFile doGetFileContent() {
            return this.getContentProvider().getReadOnlyRandomAccessFile();
        }

        protected InputStream doGetInputStream() {
            return this.getContentProvider().getInputStream();
        }

        private IFileContentProvider getContentProvider() {
            if (this.fileContentProviderOrNull == null) {
                File file = this.doGetFile();
                this.fileContentProviderOrNull = PathInfoProviderBasedHierarchicalContent.this.getFileContentProvider(file);
            }
            return this.fileContentProviderOrNull;
        }

        private File doGetFile() {
            if (StringUtils.isBlank((String)this.getRelativePath())) {
                return PathInfoProviderBasedHierarchicalContent.this.root;
            }
            return new File(PathInfoProviderBasedHierarchicalContent.this.root, this.getRelativePath());
        }
    }
}

