/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.Resources;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IContentCache;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IDssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.RemoteHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import java.util.ArrayList;
import java.util.List;

public class RemoteHierarchicalContent
implements IHierarchicalContent {
    private final IDatasetLocationNode location;
    private final ISingleDataSetPathInfoProvider provider;
    private final ISessionTokenProvider sessionTokenProvider;
    private final IContentCache cache;
    private final IDssServiceRpcGenericFactory serviceFactory;
    private final Resources resources;

    public RemoteHierarchicalContent(IDatasetLocationNode location, ISingleDataSetPathInfoProvider pathInfoProvider, IDssServiceRpcGenericFactory serviceFactory, ISessionTokenProvider sessionTokenProvider, IContentCache cache) {
        this.location = location;
        this.provider = pathInfoProvider;
        this.serviceFactory = serviceFactory;
        this.sessionTokenProvider = sessionTokenProvider;
        this.cache = cache;
        this.resources = new Resources();
    }

    public IHierarchicalContentNode getRootNode() {
        DataSetPathInfo info = null;
        if (this.provider != null) {
            info = this.provider.getRootPathInfo();
        }
        if (info == null) {
            info = new DataSetPathInfo();
            info.setDirectory(true);
            info.setRelativePath("");
            info.setParent(null);
            info.setFileName("");
        }
        return this.createNode(info);
    }

    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        IHierarchicalContentNode node = this.tryGetNode(relativePath);
        if (node == null) {
            throw new IllegalArgumentException("Resource '" + relativePath + "' does not exist.");
        }
        return node;
    }

    public IHierarchicalContentNode tryGetNode(String relativePath) {
        DataSetPathInfo info = null;
        if (this.provider != null) {
            info = this.provider.tryGetPathInfoByRelativePath(relativePath);
            if (info == null) {
                return null;
            }
        } else {
            info = new DataSetPathInfo();
            info.setDirectory(true);
            info.setRelativePath(relativePath);
            info.setParent(null);
            info.setFileName("");
        }
        return this.createNode(info);
    }

    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        List<DataSetPathInfo> paths = null;
        if (this.provider == null) {
            paths = this.provider.listMatchingPathInfos(relativePathPattern);
        }
        if (paths == null) {
            throw new UnsupportedOperationException("pattern matching not available without pathinfo db");
        }
        return this.createNodes(paths);
    }

    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        List<DataSetPathInfo> paths = null;
        if (this.provider == null) {
            paths = this.provider.listMatchingPathInfos(startingPath, fileNamePattern);
        }
        if (paths == null) {
            throw new UnsupportedOperationException("pattern matching not available without pathinfo db");
        }
        return this.createNodes(paths);
    }

    public void close() {
        this.resources.release();
    }

    private IHierarchicalContentNode createNode(DataSetPathInfo info) {
        final RemoteHierarchicalContentNode node = new RemoteHierarchicalContentNode(this.location.getLocation(), info, this.provider, this.serviceFactory, this.sessionTokenProvider, this.cache);
        this.resources.add((Object)new IReleasable(){

            public void release() {
                node.close();
            }
        });
        return node;
    }

    private List<IHierarchicalContentNode> createNodes(List<DataSetPathInfo> paths) {
        ArrayList<IHierarchicalContentNode> nodes = new ArrayList<IHierarchicalContentNode>();
        for (DataSetPathInfo info : paths) {
            nodes.add(this.createNode(info));
        }
        return nodes;
    }
}

