/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.Resources;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IContentCache;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IDssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RemoteHierarchicalContentNode
implements IHierarchicalContentNode {
    private ISingleDataSetPathInfoProvider provider;
    private ISessionTokenProvider sessionTokenProvider;
    private DataSetPathInfo path;
    private String parentRelativePath;
    private final IContentCache cache;
    private final IDatasetLocation dataSetLocation;
    private final IDssServiceRpcGenericFactory serviceFactory;
    private final Resources resources;

    public RemoteHierarchicalContentNode(IDatasetLocation dataSetetLocation, DataSetPathInfo path, ISingleDataSetPathInfoProvider provider, IDssServiceRpcGenericFactory serviceFactory, ISessionTokenProvider sessionTokenProvider, IContentCache contentCache) {
        this(dataSetetLocation, path, provider, serviceFactory, sessionTokenProvider, contentCache, null);
    }

    private RemoteHierarchicalContentNode(IDatasetLocation dataSetetLocation, DataSetPathInfo path, ISingleDataSetPathInfoProvider provider, IDssServiceRpcGenericFactory serviceFactory, ISessionTokenProvider sessionTokenProvider, IContentCache contentCache, String parentRelativePath) {
        this.dataSetLocation = dataSetetLocation;
        this.path = path;
        this.provider = provider;
        this.sessionTokenProvider = sessionTokenProvider;
        this.serviceFactory = serviceFactory;
        this.cache = contentCache;
        this.parentRelativePath = parentRelativePath;
        this.resources = new Resources();
    }

    public String getName() {
        return this.path.getFileName();
    }

    public String getRelativePath() {
        return this.path.getRelativePath();
    }

    public String getParentRelativePath() {
        return this.parentRelativePath;
    }

    public boolean exists() {
        return true;
    }

    public boolean isDirectory() {
        return this.path.isDirectory();
    }

    public long getLastModified() {
        if (this.path.getLastModified() != null) {
            return this.path.getLastModified().getTime();
        }
        return 0L;
    }

    public long getFileLength() throws UnsupportedOperationException {
        return this.path.getSizeInBytes();
    }

    public String getChecksum() throws UnsupportedOperationException {
        return this.path.getChecksum();
    }

    public int getChecksumCRC32() throws UnsupportedOperationException {
        return this.path.getChecksumCRC32();
    }

    public boolean isChecksumCRC32Precalculated() {
        return false;
    }

    public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
        ArrayList<IHierarchicalContentNode> children = new ArrayList<IHierarchicalContentNode>();
        String relativePath = this.path.getRelativePath();
        if (this.provider != null) {
            for (DataSetPathInfo childPath : this.provider.listChildrenPathInfos(this.path)) {
                children.add(new RemoteHierarchicalContentNode(this.dataSetLocation, childPath, this.provider, this.serviceFactory, this.sessionTokenProvider, this.cache, relativePath));
            }
        } else {
            FileInfoDssDTO[] files;
            IDssServiceRpcGeneric service = this.serviceFactory.getService(this.dataSetLocation.getDataStoreUrl());
            String sessionToken = this.sessionTokenProvider.getSessionToken();
            String dataSetCode = this.dataSetLocation.getDataSetCode();
            for (FileInfoDssDTO file : files = service.listFilesForDataSet(sessionToken, dataSetCode, relativePath, false)) {
                DataSetPathInfo info = new DataSetPathInfo();
                info.setChecksumCRC32(file.tryGetCrc32Checksum());
                info.setDirectory(file.isDirectory());
                info.setFileName(file.getPathInListing());
                info.setRelativePath(file.getPathInDataSet());
                info.setSizeInBytes(file.getFileSize());
                info.setLastModified(new Date(0L));
                children.add(new RemoteHierarchicalContentNode(this.dataSetLocation, info, this.provider, this.serviceFactory, this.sessionTokenProvider, this.cache, relativePath));
            }
        }
        return children;
    }

    public File getFile() throws UnsupportedOperationException {
        return this.cache.getFile(this.sessionTokenProvider.getSessionToken(), this.dataSetLocation, this.path);
    }

    public File tryGetFile() {
        try {
            return this.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
        return new RandomAccessFileImpl(this.getFile(), "r");
    }

    public InputStream getInputStream() throws UnsupportedOperationException, IOExceptionUnchecked {
        final InputStream stream = this.cache.getInputStream(this.sessionTokenProvider.getSessionToken(), this.dataSetLocation, this.path);
        this.resources.add((Object)new IReleasable(){

            public void release() {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                }
            }
        });
        return stream;
    }

    public void close() {
        this.resources.release();
    }
}

