/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.dto;

import ch.systemsx.cisd.common.time.DateFormatThreadLocal;
import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SpeedUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ToStringUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExtractableData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DataSetInformation
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String sampleCode;
    private IEntityProperty[] sampleProperties = IEntityProperty.EMPTY_ARRAY;
    private DataSetType dataSetType;
    private DataSetKind dataSetKind;
    private int speedHint = -50;
    private String shareId;
    private String instanceUUID;
    private String projectCode;
    private String spaceCode;
    private ExperimentIdentifier experimentIdentifier;
    private transient Sample sample;
    private transient boolean linkSample = true;
    private transient Experiment experiment;
    private BooleanOrUnknown isCompleteFlag = BooleanOrUnknown.U;
    private List<String> containedDataSetCodes = new ArrayList<String>();
    private String externalDataManagementSystem;
    private String externalCode;
    private ExtractableData extractableData = new ExtractableData();
    private String uploadingUserEmailOrNull;
    private String uploadingUserIdOrNull;
    private String containerDatasetPermIdOrNull;
    private AbstractExternalData containerDataSetOrNull;

    public String getShareId() {
        return this.shareId;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    public int getSpeedHint() {
        return this.speedHint;
    }

    public void setSpeedHint(int speedHint) {
        this.speedHint = SpeedUtils.trimSpeedHint(speedHint);
    }

    public String tryGetUploadingUserEmail() {
        return this.uploadingUserEmailOrNull;
    }

    public void setUploadingUserEmail(String uploadingUserEmail) {
        this.uploadingUserEmailOrNull = uploadingUserEmail;
    }

    public void setUploadingUserId(String uploadingUserIdOrNull) {
        this.uploadingUserIdOrNull = uploadingUserIdOrNull;
    }

    public String getUploadingUserIdOrNull() {
        return this.uploadingUserIdOrNull;
    }

    public final BooleanOrUnknown getIsCompleteFlag() {
        return this.isCompleteFlag;
    }

    public final void setComplete(boolean complete) {
        this.isCompleteFlag = BooleanOrUnknown.resolve((boolean)complete);
    }

    public final IEntityProperty[] getSampleProperties() {
        return this.sampleProperties == null ? new IEntityProperty[]{} : this.sampleProperties;
    }

    public final void setSampleProperties(IEntityProperty[] properties) {
        this.sampleProperties = properties;
    }

    public DataSetType getDataSetType() {
        return this.dataSetType;
    }

    public void setDataSetType(DataSetType dataSetType) {
        this.dataSetType = dataSetType;
    }

    public DataSetKind getDataSetKind() {
        return this.dataSetKind;
    }

    public void setDataSetKind(DataSetKind dataSetKind) {
        this.dataSetKind = dataSetKind;
    }

    public final String getInstanceUUID() {
        return this.instanceUUID;
    }

    public final void setInstanceUUID(String instanceUUID) {
        this.instanceUUID = instanceUUID;
    }

    public final void setExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }

    public final ExperimentIdentifier getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public Experiment tryToGetExperiment() {
        return this.experiment == null ? (this.sample == null ? null : this.sample.getExperiment()) : this.experiment;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public Sample tryToGetSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
    }

    public final SampleIdentifier getSampleIdentifier() {
        if (this.sampleCode == null) {
            return null;
        }
        if (this.projectCode != null) {
            return new SampleIdentifier(new ProjectIdentifier(this.spaceCode, this.projectCode), this.sampleCode);
        }
        if (this.spaceCode == null) {
            return new SampleIdentifier(this.sampleCode);
        }
        return new SampleIdentifier(new SpaceIdentifier(this.spaceCode), this.sampleCode);
    }

    public final void setSampleIdentifier(SampleIdentifier sampleIdentifierOrNull) {
        if (sampleIdentifierOrNull != null) {
            this.setSampleCode(sampleIdentifierOrNull.getSampleCode());
            if (sampleIdentifierOrNull.isProjectLevel()) {
                this.setProjectCode(sampleIdentifierOrNull.getProjectLevel().getProjectCode());
                this.setSpaceCode(sampleIdentifierOrNull.getProjectLevel().getSpaceCode());
            } else {
                SpaceIdentifier spaceLevel = sampleIdentifierOrNull.getSpaceLevel();
                if (spaceLevel != null) {
                    this.setSpaceCode(spaceLevel.getSpaceCode());
                }
            }
        }
    }

    public final void setSampleIdentifier(String sampleIdentifier) {
        this.setSampleIdentifier(SampleIdentifierFactory.parse((String)sampleIdentifier));
    }

    public final String getSampleCode() {
        return this.sampleCode;
    }

    public final void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
    }

    public boolean isLinkSample() {
        return this.linkSample;
    }

    public void setLinkSample(boolean linkSample) {
        this.linkSample = linkSample;
    }

    public final String getDataSetCode() {
        return this.extractableData.getCode();
    }

    public final void setDataSetCode(String dataSetCode) {
        this.extractableData.setCode(dataSetCode);
    }

    public final String getProducerCode() {
        return this.extractableData.getDataProducerCode();
    }

    public final void setProducerCode(String producerCode) {
        this.extractableData.setDataProducerCode(producerCode);
    }

    public final Date getProductionDate() {
        return this.extractableData.getProductionDate();
    }

    public final void setProductionDate(Date productionDate) {
        this.extractableData.setProductionDate(productionDate);
    }

    public final ExtractableData getExtractableData() {
        return this.extractableData;
    }

    public final void setExtractableData(ExtractableData extractableData) {
        this.extractableData = extractableData;
    }

    public final List<String> getParentDataSetCodes() {
        return this.extractableData.getParentDataSetCodes();
    }

    public final void setParentDataSetCodes(List<String> parentDataSetCodes) {
        this.extractableData.setParentDataSetCodes(parentDataSetCodes);
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public final void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    public final String getSpaceCode() {
        return this.spaceCode;
    }

    public void setDataSetProperties(List<NewProperty> dataSetProperties) {
        this.extractableData.setDataSetProperties(dataSetProperties);
    }

    public List<NewProperty> getDataSetProperties() {
        return this.extractableData.getDataSetProperties();
    }

    public List<String> getContainedDataSetCodes() {
        return this.containedDataSetCodes;
    }

    public void setContainedDataSetCodes(List<String> containedDataSetCodes) {
        this.containedDataSetCodes = containedDataSetCodes;
    }

    public boolean isContainerDataSet() {
        return false == this.containedDataSetCodes.isEmpty();
    }

    public void setExternalDataManagementSystem(String code) {
        this.externalDataManagementSystem = code;
    }

    public String getExternalDataManagementSystem() {
        return this.externalDataManagementSystem;
    }

    public boolean isLinkDataSet() {
        return this.externalDataManagementSystem != null;
    }

    public boolean isNoFileDataSet() {
        return this.isLinkDataSet() || this.isContainerDataSet();
    }

    public String getExternalCode() {
        return this.externalCode;
    }

    public void setExternalCode(String externalCode) {
        this.externalCode = externalCode;
    }

    public final String describe() {
        if (this.experimentIdentifier == null) {
            return String.format("CODE('%s') SAMPLE_CODE('%s')", this.extractableData.getCode(), this.sampleCode);
        }
        return String.format("CODE('%s') SAMPLE_CODE('%s') EXPERIMENT('%s')", this.extractableData.getCode(), this.sampleCode, this.experimentIdentifier.describe());
    }

    public String toString() {
        List<String> parentDataSetCodes;
        StringBuilder buffer = new StringBuilder();
        String userID = this.getUploadingUserIdOrNull();
        String userEMail = this.tryGetUploadingUserEmail();
        if (userID != null || userEMail != null) {
            DataSetInformation.appendNameAndObject(buffer, "User", userID == null ? userEMail : userID);
        }
        DataSetInformation.appendNameAndObject(buffer, "Data Set Code", this.getDataSetCode());
        if (null != this.getDataSetType()) {
            DataSetInformation.appendNameAndObject(buffer, "Data Set Type", this.getDataSetType().getCode());
        } else {
            DataSetInformation.appendNameAndObject(buffer, "Data Set Type", "null");
        }
        if (null != this.getDataSetKind()) {
            DataSetInformation.appendNameAndObject(buffer, "Data Set Kind", this.getDataSetKind().name());
        } else {
            DataSetInformation.appendNameAndObject(buffer, "Data Set Kind", "null");
        }
        DataSetInformation.appendNameAndObject(buffer, "Experiment Identifier", this.getExperimentIdentifier());
        DataSetInformation.appendNameAndObject(buffer, "Sample Identifier", this.getSampleIdentifier());
        if (!StringUtils.isBlank((CharSequence)this.getProducerCode())) {
            DataSetInformation.appendNameAndObject(buffer, "Producer Code", this.getProducerCode());
        }
        if (this.getProductionDate() != null) {
            DataSetInformation.appendNameAndObject(buffer, "Production Date", DataSetInformation.formatDate(this.getProductionDate()));
        }
        if (!(parentDataSetCodes = this.getParentDataSetCodes()).isEmpty()) {
            DataSetInformation.appendNameAndObject(buffer, "Parent Data Sets", StringUtils.join(parentDataSetCodes, (char)' '));
        }
        DataSetInformation.appendNameAndObject(buffer, "Is complete", this.getIsCompleteFlag());
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public String tryGetContainerDatasetPermId() {
        return this.containerDatasetPermIdOrNull;
    }

    public void setContainerDatasetPermId(String containerDatasetPermIdOrNull) {
        this.containerDatasetPermIdOrNull = containerDatasetPermIdOrNull;
    }

    public AbstractExternalData tryGetContainerDataSet() {
        return this.containerDataSetOrNull;
    }

    public void setContainerDataSet(AbstractExternalData containerDataSetOrNull) {
        this.containerDataSetOrNull = containerDataSetOrNull;
    }

    private static String formatDate(Date productionDate) {
        return productionDate == null ? "" : ((SimpleDateFormat)DateFormatThreadLocal.DATE_FORMAT.get()).format(productionDate);
    }

    protected static final void appendNameAndObject(StringBuilder buffer, String name, Object object) {
        ToStringUtil.appendNameAndObject(buffer, name, object);
    }
}

