/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.dto;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.io.IOUtilities;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;

public final class PathInfo {
    private static final List<PathInfo> NO_CHILDREN = Collections.emptyList();
    private File file;
    private String fileName;
    private long sizeInBytes;
    private Integer checksumCRC32;
    private String checksum;
    private PathInfo parent;
    private boolean directory;
    private List<PathInfo> children;
    private Date lastModifiedDate;

    public static PathInfo createPathInfo(IHierarchicalContentNode node, boolean computeChecksum, String checksumType) {
        if (!node.exists()) {
            throw new IllegalArgumentException("File does not exist: " + node.getRelativePath());
        }
        PathInfo pathInfo = new PathInfo();
        pathInfo.fileName = node.getName();
        pathInfo.lastModifiedDate = new Date(node.getLastModified());
        pathInfo.directory = node.isDirectory();
        pathInfo.file = node.tryGetFile();
        if (pathInfo.directory) {
            pathInfo.children = PathInfo.createPathInfos(node, computeChecksum, checksumType);
            long sum = 0L;
            for (PathInfo childInfo : pathInfo.children) {
                childInfo.parent = pathInfo;
                sum += childInfo.sizeInBytes;
            }
            pathInfo.sizeInBytes = sum;
        } else {
            pathInfo.sizeInBytes = node.getFileLength();
            PathInfo.setChecksum(pathInfo, node, computeChecksum, checksumType);
        }
        return pathInfo;
    }

    private static void setChecksum(PathInfo pathInfo, IHierarchicalContentNode node, boolean computeChecksum, String checksumType) {
        if (!computeChecksum) {
            return;
        }
        if (checksumType == null) {
            pathInfo.checksumCRC32 = node.getChecksumCRC32();
            return;
        }
        PathInfo.setChecksum(pathInfo, node.getInputStream(), computeChecksum, checksumType);
    }

    public static void setChecksum(PathInfo pathInfo, InputStream inputStream, boolean computeChecksum, String checksumType) {
        if (computeChecksum) {
            if (checksumType == null) {
                pathInfo.checksumCRC32 = IOUtilities.getChecksumCRC32((InputStream)inputStream);
            } else {
                MessageDigest messageDigest = PathInfo.getMessageDigest(checksumType);
                CRC32 crc = new CRC32();
                PathInfo.feedChecksumCalculators(inputStream, messageDigest, crc);
                pathInfo.checksumCRC32 = (int)crc.getValue();
                pathInfo.checksum = PathInfo.renderChecksum(checksumType, messageDigest);
            }
        }
    }

    private static String renderChecksum(String checksumType, MessageDigest messageDigest) {
        StringBuilder builder = new StringBuilder(checksumType).append(':');
        for (byte b : messageDigest.digest()) {
            int v = b & 0xFF;
            builder.append(Integer.toHexString(v >> 4)).append(Integer.toHexString(v & 0xF));
        }
        return builder.toString();
    }

    private static void feedChecksumCalculators(InputStream inputStream, MessageDigest messageDigest, CRC32 crc) {
        try {
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, n);
                crc.update(buffer, 0, n);
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    static MessageDigest getMessageDigest(String checksumType) {
        try {
            return MessageDigest.getInstance(checksumType);
        }
        catch (NoSuchAlgorithmException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private static List<PathInfo> createPathInfos(IHierarchicalContentNode node, boolean computeChecksum, String checksumType) {
        if (!node.isDirectory()) {
            throw new IllegalArgumentException("Not a folder: " + node.getRelativePath());
        }
        ArrayList<PathInfo> childInfos = new ArrayList<PathInfo>();
        List childNodes = node.getChildNodes();
        for (IHierarchicalContentNode child : childNodes) {
            childInfos.add(PathInfo.createPathInfo(child, computeChecksum, checksumType));
        }
        Collections.sort(childInfos, new Comparator<PathInfo>(){

            @Override
            public int compare(PathInfo p1, PathInfo p2) {
                return p1.getFileName().compareTo(p2.getFileName());
            }
        });
        return childInfos;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Integer getChecksumCRC32() {
        return this.checksumCRC32;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public PathInfo getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public List<PathInfo> getChildren() {
        return this.children == null ? NO_CHILDREN : Collections.unmodifiableList(this.children);
    }
}

