/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetFileLines;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class CsvFileReaderHelper {
    public static CsvReader getCsvReader(File file) throws IOException {
        return CsvFileReaderHelper.getCsvReader(file, new DefaultCsvFileReaderConfiguration());
    }

    public static CsvReader getCsvReader(File file, ICsvFileReaderConfiguration configuration) throws IOException {
        if (!file.isFile()) {
            throw new UserFailureException(file + " does not exist or is not a file.");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        CsvReader csvReader = new CsvReader((InputStream)fileInputStream, Charset.defaultCharset());
        csvReader.setDelimiter(configuration.getColumnDelimiter());
        csvReader.setUseComments(configuration.isIgnoreComments());
        csvReader.setComment(configuration.getCommentDelimiter());
        csvReader.setSkipEmptyRecords(configuration.isSkipEmptyRecords());
        return csvReader;
    }

    public static DatasetFileLines getDatasetFileLines(File file) throws IOException {
        return CsvFileReaderHelper.getDatasetFileLines(file, new DefaultCsvFileReaderConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetFileLines getDatasetFileLines(File file, ICsvFileReaderConfiguration configuration) throws IOException {
        try (CsvReader reader = null;){
            reader = CsvFileReaderHelper.getCsvReader(file, configuration);
            ArrayList<String[]> lines = new ArrayList<String[]>();
            while (reader.readRecord()) {
                lines.add(reader.getValues());
            }
            DatasetFileLines datasetFileLines = new DatasetFileLines(file, file.getPath(), lines);
            return datasetFileLines;
        }
    }

    public static class DefaultTsvFileReaderConfiguration
    extends DefaultCsvFileReaderConfiguration {
        @Override
        public char getColumnDelimiter() {
            return '\t';
        }
    }

    public static class DefaultCsvFileReaderConfiguration
    implements ICsvFileReaderConfiguration {
        public static final ICsvFileReaderConfiguration INSTANCE = new DefaultCsvFileReaderConfiguration();

        @Override
        public char getColumnDelimiter() {
            return ';';
        }

        @Override
        public char getCommentDelimiter() {
            return '#';
        }

        @Override
        public boolean isIgnoreComments() {
            return true;
        }

        @Override
        public boolean isSkipEmptyRecords() {
            return true;
        }
    }

    public static interface ICsvFileReaderConfiguration {
        public boolean isIgnoreComments();

        public boolean isSkipEmptyRecords();

        public char getColumnDelimiter();

        public char getCommentDelimiter();
    }
}

