/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngFilterType;
import ar.com.hjg.pngj.PngWriter;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.image.ImageHistogram;
import ch.systemsx.cisd.common.image.IntensityRescaling;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtilReaderPool;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PngWritingHelper;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ImageUtil {
    public static final String TIFF_FILE = "tif";
    public static final String PNG_FILE = "png";
    public static final String JPEG_FILE = "jpg";
    public static final String GIF_FILE = "gif";
    public static final float DEFAULT_IMAGE_OPTIMAL_RESCALING_FACTOR = 0.01f;
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageUtil.class);
    private static final Set<String> FILE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("gif", "jpg", "jpeg", "png", "tif", "tiff")));
    private static final MagicNumbersManager MAGIC_NUMBERS_MANAGER = new MagicNumbersManager(new MagicNumber("gif", "474946383961", "474946383761"), new MagicNumber("jpg", "ffd8ff"), new MagicNumber("png", "89504e470d0a1a0a"), new MagicNumber("tif", "49492a00", "4d4d002a"));
    private static final Map<String, ImageLoader> imageLoaders = new HashMap<String, ImageLoader>();
    private static ThreadLocal<String> sessionIdThreadLocal;
    private static ImageUtilReaderPool<ReaderAndFileHandler> globalReaderPool;

    private static BufferedImage loadWithImageJ(IRandomAccessFile handle) {
        return ImageUtil.loadWithLibrary(handle, ImageID.NULL, "IJ", "tiff");
    }

    private static Dimension loadDimensionWithImageJ(IRandomAccessFile handle) {
        return ImageUtil.loadDimensionWithLibrary(handle, ImageID.NULL, "IJ", "tiff");
    }

    private static int loadColorDepthWithImageJ(IRandomAccessFile handle) {
        return ImageUtil.loadColorDepthWithLibrary(handle, ImageID.NULL, "IJ", "tiff");
    }

    private static BufferedImage loadWithBioFormats(IRandomAccessFile handle, ImageID imageID) {
        return ImageUtil.loadWithLibrary(handle, imageID, "BioFormats", "TiffDelegateReader");
    }

    private static Dimension loadDimensionWithBioFormats(IRandomAccessFile handle, ImageID imageID) {
        return ImageUtil.loadDimensionWithLibrary(handle, imageID, "BioFormats", "TiffDelegateReader");
    }

    private static int loadColorDepthWithBioFormats(IRandomAccessFile handle, ImageID imageID) {
        return ImageUtil.loadColorDepthWithLibrary(handle, imageID, "BioFormats", "TiffDelegateReader");
    }

    public static BufferedImage loadJavaAdvancedImagingTiff(IRandomAccessFile handle, ImageID imageID) throws EnvironmentFailureException {
        return ImageUtil.loadWithLibrary(handle, imageID, "JAI", "tiff");
    }

    public static Dimension loadDimensionJavaAdvancedImagingTiff(IRandomAccessFile handle, ImageID imageID) throws EnvironmentFailureException {
        return ImageUtil.loadDimensionWithLibrary(handle, imageID, "JAI", "tiff");
    }

    public static int loadColorDepthJavaAdvancedImagingTiff(IRandomAccessFile handle, ImageID imageID) throws EnvironmentFailureException {
        return ImageUtil.loadColorDepthWithLibrary(handle, imageID, "JAI", "tiff");
    }

    private static BufferedImage loadWithLibrary(IRandomAccessFile handle, ImageID imageIDOrNull, String libraryName, String readerName) {
        operationLog.debug((Object)("Load tiff image using " + libraryName));
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
        if (imageReader == null) {
            throw new IllegalStateException(String.format("There is no reader '%s' in image library '%s'.", readerName, libraryName));
        }
        try {
            return imageReader.readImage(handle, imageIDOrNull, null);
        }
        catch (Exception ex) {
            throw EnvironmentFailureException.fromTemplate((String)"Cannot decode image.", (Object[])new Object[]{ex});
        }
    }

    private static Dimension loadDimensionWithLibrary(IRandomAccessFile handle, ImageID imageIDOrNull, String libraryName, String readerName) {
        operationLog.debug((Object)("Load tiff image using " + libraryName));
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
        if (imageReader == null) {
            throw new IllegalStateException(String.format("There is no reader '%s' in image library '%s'.", readerName, libraryName));
        }
        try {
            return imageReader.readDimensions(handle, imageIDOrNull);
        }
        catch (Exception ex) {
            throw EnvironmentFailureException.fromTemplate((String)"Cannot decode image.", (Object[])new Object[]{ex});
        }
    }

    private static int loadColorDepthWithLibrary(IRandomAccessFile handle, ImageID imageIDOrNull, String libraryName, String readerName) {
        operationLog.debug((Object)("Load tiff image using " + libraryName));
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)libraryName, (String)readerName);
        if (imageReader == null) {
            throw new IllegalStateException(String.format("There is no reader '%s' in image library '%s'.", readerName, libraryName));
        }
        try {
            return imageReader.readColorDepth(handle, imageIDOrNull);
        }
        catch (Exception ex) {
            throw EnvironmentFailureException.fromTemplate((String)"Cannot decode image.", (Object[])new Object[]{ex});
        }
    }

    public static boolean isImageFile(File file) {
        String fileName = file.getName();
        String fileType = FilenameUtils.getExtension((String)fileName);
        return fileType != null && FILE_TYPES.contains(fileType.toLowerCase());
    }

    public static BufferedImage loadUnchangedImage(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull, IReadParams params) {
        IReadingOperation<BufferedImage> operation = new IReadingOperation<BufferedImage>(){

            @Override
            public BufferedImage read(IImageReader imageReader, IRandomAccessFile handle, ImageID imageID, IReadParams p) {
                return imageReader.readImage(handle, imageID, p);
            }

            @Override
            public BufferedImage read(ImageLoader imageLoader, IRandomAccessFile handle, ImageID imageID) {
                return imageLoader.load(handle, imageID);
            }
        };
        return ImageUtil.loadUnchangedData(contentNode, imageIdOrNull, imageLibraryNameOrNull, imageLibraryReaderNameOrNull, params, operation);
    }

    public static void setThreadLocalSessionId(String sessionId) {
        sessionIdThreadLocal.set(sessionId);
    }

    public static String getThreadLocalSessionId() {
        return sessionIdThreadLocal.get();
    }

    public static void closeSession(String sessionId) {
        globalReaderPool.releaseSession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T loadUnchangedData(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull, IReadParams params, IReadingOperation<T> operation) {
        assert (imageLibraryReaderNameOrNull == null || imageLibraryNameOrNull != null) : "if image reader is specified then library name should be specified as well";
        ImageID imageID = ImageUtil.parseImageID(imageIdOrNull, contentNode);
        String sessionId = sessionIdThreadLocal.get();
        ReaderAndFileHandler reader = globalReaderPool.get(sessionId, imageLibraryNameOrNull, imageLibraryReaderNameOrNull);
        if (reader == null) {
            return ImageUtil.loadUnchangedDataGuessingLibrary(contentNode, operation, imageID);
        }
        try {
            T result;
            reader.setFileHandler(contentNode);
            T t = result = operation.read(reader.imageReader, reader.handle, imageID, params);
            return t;
        }
        finally {
            if (sessionId != null) {
                globalReaderPool.put(sessionId, reader);
            } else {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T loadUnchangedDataGuessingLibrary(IHierarchicalContentNode contentNode, IReadingOperation<T> operation, ImageID imageID) {
        IRandomAccessFile handle = contentNode.getFileContent();
        String fileType = ImageUtil.tryToFigureOutFileTypeOf(handle);
        try {
            if (fileType == null) {
                throw new IllegalArgumentException("File type of an image input stream couldn't be determined.");
            }
            ImageLoader imageLoader = imageLoaders.get(fileType);
            if (imageLoader == null) {
                throw new IllegalArgumentException("Unable to load image of file type '" + fileType + "'.");
            }
            T t = operation.read(imageLoader, handle, imageID);
            return t;
        }
        finally {
            ImageUtil.closeQuietly(handle);
        }
    }

    public static Dimension loadUnchangedImageDimension(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
        IReadingOperation<Dimension> operation = new IReadingOperation<Dimension>(){

            @Override
            public Dimension read(IImageReader imageReader, IRandomAccessFile handle, ImageID imageID, IReadParams params) {
                return imageReader.readDimensions(handle, imageID);
            }

            @Override
            public Dimension read(ImageLoader imageLoader, IRandomAccessFile handle, ImageID imageID) {
                return imageLoader.readDimension(handle, imageID);
            }
        };
        return ImageUtil.loadUnchangedData(contentNode, imageIdOrNull, imageLibraryNameOrNull, imageLibraryReaderNameOrNull, null, operation);
    }

    public static int loadUnchangedImageColorDepth(IHierarchicalContentNode contentNode, String imageIdOrNull, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
        IReadingOperation<Integer> operation = new IReadingOperation<Integer>(){

            @Override
            public Integer read(IImageReader imageReader, IRandomAccessFile handle, ImageID imageID, IReadParams params) {
                return imageReader.readColorDepth(handle, imageID);
            }

            @Override
            public Integer read(ImageLoader imageLoader, IRandomAccessFile handle, ImageID imageID) {
                return imageLoader.readColorDepth(handle, imageID);
            }
        };
        return ImageUtil.loadUnchangedData(contentNode, imageIdOrNull, imageLibraryNameOrNull, imageLibraryReaderNameOrNull, null, operation);
    }

    public static byte[] imageToPngFast(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writeImageToPngFast(image, out);
        return out.toByteArray();
    }

    public static void writeImageToPngFast(BufferedImage image, OutputStream out) {
        ImageUtil.writeImageToPng(image, out, PngFilterType.FILTER_DEFAULT, 0);
    }

    public static byte[] imageToPng(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writeImageToPng(image, out);
        return out.toByteArray();
    }

    public static void writeImageToPng(BufferedImage image, OutputStream out) {
        ImageUtil.writeImageToPng(image, out, PngFilterType.FILTER_DEFAULT, 6);
    }

    public static byte[] imageToPng(BufferedImage image, PngFilterType filterType, int compressionLevel) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.writeImageToPng(image, out, filterType, compressionLevel);
        return out.toByteArray();
    }

    public static void writeImageToPng(BufferedImage image, OutputStream out, PngFilterType filterType, int compressionLevel) {
        PngWritingHelper helper = PngWritingHelper.createHelper(image);
        ImageInfo imgInfo = helper.getImageInfo();
        int rows = imgInfo.rows;
        PngWriter png = new PngWriter(out, imgInfo);
        png.setFilterType(filterType == null ? PngFilterType.FILTER_DEFAULT : filterType);
        png.setCompLevel(compressionLevel == -1 ? 6 : compressionLevel);
        ImageLine imageLine = new ImageLine(imgInfo);
        for (int row = 0; row < rows; ++row) {
            helper.fillLine(imageLine, row);
            imageLine.setRown(row);
            png.writeRow(imageLine);
        }
        png.end();
    }

    public static void writeImageUsingImageIO(BufferedImage image, OutputStream out, String format) throws IOExceptionUnchecked {
        try {
            ImageIO.write((RenderedImage)image, format, out);
        }
        catch (IOException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    public static ImageID parseImageID(String imageIdOrNull, IHierarchicalContentNode contentNode) {
        ImageID id = imageIdOrNull == null ? ImageID.NULL : ImageID.parse((String)imageIdOrNull);
        try {
            File fileOrNull = contentNode.tryGetFile();
            if (fileOrNull != null) {
                id.setFileName(fileOrNull.getCanonicalPath());
            }
        }
        catch (Exception ex) {
            operationLog.warn((Object)"Unable to set file name on image id. ", (Throwable)ex);
        }
        return id;
    }

    @Private
    static BufferedImage loadImage(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
        return ImageUtil.loadImage((IHierarchicalContentNode)new FileBasedContentNode(file));
    }

    @Private
    static BufferedImage loadImage(IHierarchicalContentNode contentNode) {
        return ImageUtil.loadUnchangedImage(contentNode, null, null, null, null);
    }

    public static BufferedImage loadImageForDisplay(IHierarchicalContentNode contentNode, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        if (!contentNode.exists()) {
            throw new IllegalArgumentException("File does not exist: " + contentNode.getRelativePath());
        }
        BufferedImage result = ImageUtil.loadImage(contentNode);
        result = ImageUtil.convertForDisplayIfNecessary(result, null, converterOrNull);
        return result;
    }

    public static BufferedImage createThumbnailForDisplay(BufferedImage image, int maxWidth, int maxHeight, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        BufferedImage result = ImageUtil.rescale(image, maxWidth, maxHeight, true, false, converterOrNull);
        result = ImageUtil.convertForDisplayIfNecessary(result, null, converterOrNull);
        return result;
    }

    private static BufferedImage convertForDisplayIfNecessary(BufferedImage image, Float threshold, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        return ImageUtil.convertForDisplayIfNecessary(image, threshold, null, converterOrNull);
    }

    private static BufferedImage convertForDisplayIfNecessary(BufferedImage image, Float threshold, IntensityRescaling.Channel representativeChannelOrNull, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        IntensityRescaling.Channel channel = ImageUtil.getRepresentativeChannelIfEffectiveGrayAndMoreThan8Bit(image, representativeChannelOrNull);
        if (channel != null) {
            IntensityRescaling.Pixels pixels = converterOrNull == null ? new IntensityRescaling.Pixels(image) : converterOrNull.convert(image);
            IntensityRescaling.Levels intensityRange = IntensityRescaling.computeLevels((IntensityRescaling.Pixels)pixels, (float)(threshold == null ? 0.01f : threshold.floatValue()), (IntensityRescaling.Channel[])new IntensityRescaling.Channel[]{channel});
            ImageUtil.convertToGray(pixels);
            BufferedImage result = IntensityRescaling.rescaleIntensityLevelTo8Bits((IntensityRescaling.Pixels)pixels, (IntensityRescaling.Levels)intensityRange, (IntensityRescaling.Channel[])IntensityRescaling.Channel.values());
            return result;
        }
        return image;
    }

    private static void convertToGray(IntensityRescaling.Pixels pixels) {
        int[][] pixelData = pixels.getPixelData();
        if (pixelData.length > 1) {
            int n = pixelData[0].length;
            for (int i = 0; i < n; ++i) {
                int c;
                int max = 0;
                for (c = 0; c < pixelData.length; ++c) {
                    max = Math.max(max, pixelData[c][i]);
                }
                for (c = 0; c < pixelData.length; ++c) {
                    pixelData[c][i] = max;
                }
            }
        }
    }

    private static IntensityRescaling.Channel getRepresentativeChannelIfEffectiveGrayAndMoreThan8Bit(BufferedImage image, IntensityRescaling.Channel representativeChannelOrNull) {
        if (ImageUtil.getMaxNumberOfBitsPerComponent(image) <= 8) {
            return null;
        }
        ColorModel colorModel = image.getColorModel();
        if (image.getType() != 0) {
            return colorModel.getNumColorComponents() == 1 ? IntensityRescaling.Channel.RED : null;
        }
        return representativeChannelOrNull != null ? representativeChannelOrNull : ImageUtil.getRepresentativeChannelIfEffectiveGray(image);
    }

    public static int getMaxNumberOfBitsPerComponent(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        int[] componentSize = colorModel.getComponentSize();
        if (componentSize == null) {
            return colorModel.getPixelSize();
        }
        int max = 0;
        for (int size : componentSize) {
            max = Math.max(max, size);
        }
        return max;
    }

    public static IntensityRescaling.Channel getRepresentativeChannelIfEffectiveGray(BufferedImage image) {
        ImageHistogram imageHistogram = ImageHistogram.calculateHistogram((BufferedImage)image);
        LinkedHashMap<IntensityRescaling.Channel, int[]> histogramsByChannels = new LinkedHashMap<IntensityRescaling.Channel, int[]>();
        int numberOfPixels = image.getWidth() * image.getHeight();
        ImageUtil.checkIfChannelIsUsed(histogramsByChannels, numberOfPixels, IntensityRescaling.Channel.RED, imageHistogram.getRedHistogram());
        ImageUtil.checkIfChannelIsUsed(histogramsByChannels, numberOfPixels, IntensityRescaling.Channel.GREEN, imageHistogram.getGreenHistogram());
        ImageUtil.checkIfChannelIsUsed(histogramsByChannels, numberOfPixels, IntensityRescaling.Channel.BLUE, imageHistogram.getBlueHistogram());
        if (histogramsByChannels.isEmpty()) {
            return IntensityRescaling.Channel.RED;
        }
        ArrayList usedChannels = new ArrayList(histogramsByChannels.entrySet());
        int[] representativeHistogram = (int[])((Map.Entry)usedChannels.get(0)).getValue();
        for (int i = 1; i < usedChannels.size(); ++i) {
            int[] histogram = (int[])((Map.Entry)usedChannels.get(i)).getValue();
            for (int j = 0; j < histogram.length; ++j) {
                if (histogram[j] == representativeHistogram[j]) continue;
                return null;
            }
        }
        return (IntensityRescaling.Channel)((Map.Entry)usedChannels.get(0)).getKey();
    }

    private static void checkIfChannelIsUsed(Map<IntensityRescaling.Channel, int[]> usedChannels, int numberOfPixels, IntensityRescaling.Channel channel, int[] histogram) {
        if (histogram[0] < numberOfPixels) {
            usedChannels.put(channel, histogram);
        }
    }

    public static BufferedImage rescale(BufferedImage image, int maxWidth, int maxHeight, boolean enlargeIfNecessary, boolean highQuality8Bit, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        return ImageUtil.rescale(image, maxWidth, maxHeight, enlargeIfNecessary, highQuality8Bit, null, converterOrNull);
    }

    public static BufferedImage rescale(BufferedImage image, int maxWidth, int maxHeight, boolean enlargeIfNecessary, boolean highQuality8Bit, IntensityRescaling.Channel representativeChannelOrNull, IntensityRescaling.IImageToPixelsConverter converterOrNull) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (width == maxWidth && maxHeight >= height || height == maxHeight && maxWidth >= width) {
            return image;
        }
        double widthScale = (double)maxWidth / (double)width;
        double heightScale = (double)maxHeight / (double)height;
        double scale = Math.min(widthScale, heightScale);
        if (!enlargeIfNecessary && scale > 1.0) {
            return image;
        }
        int thumbnailWidth = (int)(scale * (double)width + 0.5);
        int thumbnailHeight = (int)(scale * (double)height + 0.5);
        BufferedImage thumbnail = ImageUtil.createNewEmptyImage(image, highQuality8Bit, thumbnailWidth, thumbnailHeight);
        Graphics2D graphics2D = thumbnail.createGraphics();
        BufferedImage imageToRescale = image;
        if (highQuality8Bit) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            imageToRescale = ImageUtil.convertForDisplayIfNecessary(imageToRescale, Float.valueOf(0.0f), representativeChannelOrNull, converterOrNull);
        }
        graphics2D.drawImage(imageToRescale, 0, 0, thumbnailWidth, thumbnailHeight, null);
        graphics2D.dispose();
        return thumbnail;
    }

    public static BufferedImage convertToRGB(BufferedImage image) {
        if (image.getType() == 1 || image.getType() == 2) {
            return image;
        }
        BufferedImage thumbnail = ImageUtil.createNewEmptyImage(image, false, image.getWidth(), image.getHeight());
        Graphics2D graphics2D = thumbnail.createGraphics();
        graphics2D.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        graphics2D.dispose();
        return thumbnail;
    }

    private static BufferedImage createNewEmptyImage(BufferedImage image, boolean highQuality8Bit, int thumbnailWidth, int thumbnailHeight) {
        boolean isTransparent = image.getColorModel().hasAlpha();
        int imageType = image.getType();
        imageType = highQuality8Bit ? (imageType == 11 ? 10 : 1) : (imageType == 13 ? 1 : (isTransparent ? 2 : 1));
        BufferedImage thumbnail = new BufferedImage(thumbnailWidth, thumbnailHeight, imageType);
        return thumbnail;
    }

    private static void closeQuietly(IRandomAccessFile handle) {
        try {
            handle.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String tryToFigureOutFileTypeOf(IRandomAccessFile handle) {
        if (!handle.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support marking. Wrap input stream with a BufferedInputStream to solve the problem.");
        }
        int maxLength = MAGIC_NUMBERS_MANAGER.getMaxLength();
        handle.mark(maxLength);
        byte[] initialBytes = new byte[maxLength];
        handle.read(initialBytes);
        handle.reset();
        return MAGIC_NUMBERS_MANAGER.tryToFigureOutFileTypeOf(initialBytes);
    }

    public static boolean isTiff(String fileTypeOrNull) {
        return TIFF_FILE.equals(fileTypeOrNull);
    }

    public static boolean isJpeg(String fileTypeOrNull) {
        return JPEG_FILE.equals(fileTypeOrNull);
    }

    public static boolean isPng(String fileTypeOrNull) {
        return PNG_FILE.equals(fileTypeOrNull);
    }

    public static boolean isGif(String fileTypeOrNull) {
        return GIF_FILE.equals(fileTypeOrNull);
    }

    static {
        imageLoaders.put(GIF_FILE, new JavaImageLoader(GIF_FILE));
        imageLoaders.put(JPEG_FILE, new JavaImageLoader(JPEG_FILE));
        imageLoaders.put(PNG_FILE, new JavaImageLoader(PNG_FILE));
        imageLoaders.put(TIFF_FILE, new TiffImageLoader());
        sessionIdThreadLocal = new ThreadLocal();
        globalReaderPool = new ImageUtilReaderPool<ReaderAndFileHandler>(new ImageUtilReaderPool.ReaderUtil<ReaderAndFileHandler>(){

            @Override
            public ReaderAndFileHandler create(String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)imageLibraryNameOrNull, (String)imageLibraryReaderNameOrNull);
                if (imageReader == null) {
                    return null;
                }
                ReaderAndFileHandler reader = new ReaderAndFileHandler(imageLibraryNameOrNull, imageLibraryReaderNameOrNull);
                reader.setImageReader(imageReader);
                return reader;
            }

            @Override
            public boolean isSameLibraryAndReader(ReaderAndFileHandler reader, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
                return reader.imageLibraryName.equals(imageLibraryNameOrNull) && reader.imageLibraryReaderName.equals(imageLibraryReaderNameOrNull);
            }

            @Override
            public void close(ReaderAndFileHandler reader) {
                reader.close();
            }
        });
    }

    private static class ReaderAndFileHandler {
        private IImageReader imageReader;
        private IRandomAccessFile handle;
        private String filePath;
        private String imageLibraryName;
        private String imageLibraryReaderName;

        public ReaderAndFileHandler(String imageLibraryName, String imageLibraryReaderName) {
            this.imageLibraryName = imageLibraryName;
            this.imageLibraryReaderName = imageLibraryReaderName;
        }

        void setFileHandler(IHierarchicalContentNode contentNode) {
            String newFilePath = contentNode.getRelativePath();
            if (newFilePath.equals(this.filePath)) {
                return;
            }
            this.filePath = newFilePath;
            if (this.handle != null) {
                ImageUtil.closeQuietly(this.handle);
            }
            this.handle = contentNode.getFileContent();
        }

        void close() {
            ImageUtil.closeQuietly(this.handle);
            this.imageReader.close();
        }

        void setImageReader(IImageReader imageReader) {
            this.imageReader = imageReader;
        }
    }

    private static final class JavaImageLoader
    implements ImageLoader {
        private final String fileType;

        JavaImageLoader(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public BufferedImage load(IRandomAccessFile handle, ImageID imageID) {
            if (imageID.equals((Object)ImageID.NULL)) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)this.fileType);
                if (imageReader == null) {
                    throw EnvironmentFailureException.fromTemplate((String)"Cannot find ImageIO reader for file type '%s'", (Object[])new Object[]{this.fileType});
                }
                return imageReader.readImage(handle, ImageID.NULL, null);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension readDimension(IRandomAccessFile handle, ImageID imageID) {
            if (imageID.equals((Object)ImageID.NULL)) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)this.fileType);
                if (imageReader == null) {
                    throw EnvironmentFailureException.fromTemplate((String)"Cannot find ImageIO reader for file type '%s'", (Object[])new Object[]{this.fileType});
                }
                return imageReader.readDimensions(handle, imageID);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int readColorDepth(IRandomAccessFile handle, ImageID imageID) {
            if (imageID.equals((Object)ImageID.NULL)) {
                IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)this.fileType);
                if (imageReader == null) {
                    throw EnvironmentFailureException.fromTemplate((String)"Cannot find ImageIO reader for file type '%s'", (Object[])new Object[]{this.fileType});
                }
                return imageReader.readColorDepth(handle, imageID);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static final class TiffImageLoader
    implements ImageLoader {
        private static final int MAX_READ_AHEAD = 30000000;

        private TiffImageLoader() {
        }

        @Override
        public BufferedImage load(IRandomAccessFile handle, ImageID imageID) {
            handle.mark(30000000);
            try {
                return ImageUtil.loadWithBioFormats(handle, imageID);
            }
            catch (RuntimeException ex1) {
                try {
                    return ImageUtil.loadJavaAdvancedImagingTiff(handle, imageID);
                }
                catch (RuntimeException ex2) {
                    if (imageID.equals((Object)ImageID.NULL)) {
                        handle.reset();
                        return ImageUtil.loadWithImageJ(handle);
                    }
                    throw ex2;
                }
            }
        }

        @Override
        public Dimension readDimension(IRandomAccessFile handle, ImageID imageID) {
            handle.mark(30000000);
            try {
                return ImageUtil.loadDimensionWithBioFormats(handle, imageID);
            }
            catch (RuntimeException ex1) {
                try {
                    return ImageUtil.loadDimensionJavaAdvancedImagingTiff(handle, imageID);
                }
                catch (RuntimeException ex2) {
                    if (imageID.equals((Object)ImageID.NULL)) {
                        handle.reset();
                        return ImageUtil.loadDimensionWithImageJ(handle);
                    }
                    throw ex2;
                }
            }
        }

        @Override
        public int readColorDepth(IRandomAccessFile handle, ImageID imageID) {
            handle.mark(30000000);
            try {
                return ImageUtil.loadColorDepthWithBioFormats(handle, imageID);
            }
            catch (RuntimeException ex1) {
                try {
                    return ImageUtil.loadColorDepthJavaAdvancedImagingTiff(handle, imageID);
                }
                catch (RuntimeException ex2) {
                    if (imageID.equals((Object)ImageID.NULL)) {
                        handle.reset();
                        return ImageUtil.loadColorDepthWithImageJ(handle);
                    }
                    throw ex2;
                }
            }
        }
    }

    private static final class MagicNumbersManager {
        private final MagicNumber[] magicNumbers;

        MagicNumbersManager(MagicNumber ... magicNumbers) {
            this.magicNumbers = magicNumbers;
        }

        int getMaxLength() {
            int max = 0;
            for (MagicNumber magicNumber : this.magicNumbers) {
                max = Math.max(max, magicNumber.getMaxLength());
            }
            return max;
        }

        String tryToFigureOutFileTypeOf(byte[] initialBytes) {
            for (MagicNumber magicNumber : this.magicNumbers) {
                if (!magicNumber.matches(initialBytes)) continue;
                return magicNumber.getFileType();
            }
            return null;
        }
    }

    private static final class MagicNumber {
        private final String fileType;
        private final String[] magicHexNumbers;
        private final int maxLength;

        MagicNumber(String fileType, String ... magicHexNumbers) {
            this.fileType = fileType;
            this.magicHexNumbers = magicHexNumbers;
            int length = 0;
            for (String magicNumber : magicHexNumbers) {
                length = Math.max(length, magicNumber.length());
            }
            this.maxLength = length / 2;
        }

        public String getFileType() {
            return this.fileType;
        }

        int getMaxLength() {
            return this.maxLength;
        }

        public boolean matches(byte[] bytes) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.maxLength; ++i) {
                byte b = bytes[i];
                builder.append(Integer.toHexString(b >> 4 & 0xF));
                builder.append(Integer.toHexString(b & 0xF));
            }
            String initialBytes = builder.toString().toLowerCase();
            for (String magicNumber : this.magicHexNumbers) {
                if (!initialBytes.startsWith(magicNumber)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface IReadingOperation<T> {
        public T read(IImageReader var1, IRandomAccessFile var2, ImageID var3, IReadParams var4);

        public T read(ImageLoader var1, IRandomAccessFile var2, ImageID var3);
    }

    private static interface ImageLoader {
        public BufferedImage load(IRandomAccessFile var1, ImageID var2);

        public Dimension readDimension(IRandomAccessFile var1, ImageID var2);

        public int readColorDepth(IRandomAccessFile var1, ImageID var2);
    }
}

