/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class PostgresPlusFileSystemFreeSpaceProvider
implements IFreeSpaceProvider {
    static final String EXECUTE_VACUUM_KEY = "execute-vacuum";
    static final String DATA_SOURCE_KEY = "monitored-data-source";
    private static final String VACUUM_QUERY = "VACUUM;";
    private static final String CREATE_TMP_FREE_SPACE_TABLE = "CREATE TEMPORARY TABLE freespace ON COMMIT DROP AS    (SELECT relname, (SELECT free_space FROM pgstattuple(relid))        AS free_space FROM pg_catalog.pg_statio_user_tables);";
    private static final String SELECT_FREE_SPACE_QUERY = "SELECT sum(free_space) FROM freespace;";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PostgresPlusFileSystemFreeSpaceProvider.class);
    private final boolean executeVacuum;
    private final DataSource dataSource;
    private final IFreeSpaceProvider fileSystemFreeSpaceProvider;

    public PostgresPlusFileSystemFreeSpaceProvider(Properties properties) {
        this(properties, (IFreeSpaceProvider)new SimpleFreeSpaceProvider());
    }

    PostgresPlusFileSystemFreeSpaceProvider(Properties properties, IFreeSpaceProvider fileSystemFreeSpaceProvider) {
        this.executeVacuum = PropertyUtils.getBoolean((Properties)properties, (String)EXECUTE_VACUUM_KEY, (boolean)false);
        String dataSourceName = PropertyUtils.getMandatoryProperty((Properties)properties, (String)DATA_SOURCE_KEY);
        this.dataSource = ServiceProvider.getDataSourceProvider().getDataSource(dataSourceName);
        this.fileSystemFreeSpaceProvider = fileSystemFreeSpaceProvider;
    }

    public long freeSpaceKb(HostAwareFile path) throws IOException {
        long dataSourceFreeSpace = this.calculateDataSourceFreeSpace() / 1024L;
        long fsFreeSpace = this.fileSystemFreeSpaceProvider.freeSpaceKb(path);
        return dataSourceFreeSpace + fsFreeSpace;
    }

    private long calculateDataSourceFreeSpace() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            if (this.executeVacuum) {
                this.executeVacuumQuery(connection);
            }
            long l = this.calculateFreeSpace(connection);
            return l;
        }
        catch (SQLException sqlEx) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)sqlEx);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void executeVacuumQuery(Connection connection) throws SQLException {
        connection.createStatement().execute(VACUUM_QUERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateFreeSpace(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        try {
            connection.createStatement().execute(CREATE_TMP_FREE_SPACE_TABLE);
            ResultSet result = connection.createStatement().executeQuery(SELECT_FREE_SPACE_QUERY);
            result.next();
            long l = result.getLong(1);
            return l;
        }
        finally {
            connection.setAutoCommit(true);
        }
    }

    private Connection createConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                operationLog.error((Object)ex);
            }
        }
    }
}

